<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$item = $this->item;
$pay = $this->order->list_order_detail[0];
$customer = $this->order->customer[0];
$price = $item->price;
$subtotal = $item->total;
$tax = $this->order->total_tax;
$total = $subtotal + $tax;
$rate_order = isset($this->order->list_rate)?reset($this->order->list_rate):array();
$day_recurring = isset($this->order->order_day_recurring)?$this->order->order_day_recurring:array();
?>
<div class="row list-cart">
    <div class="col-md-12 ">
        <div class="wrapper-order-detail">
            <div class="check">
                <div class="image">
                    <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->service_image) ?>" alt="service-cover" />
                </div>
            </div>
            <div class="information">
                <h4><?php esc_html_e($this->order->customer_full_name) ?></h4>
                <p class="service-name"><?php esc_html_e($item->service_name) ?></p>
                <div class="employee-location">
                    <p class="employee-name">
                        <i class="icon-nb-phone-call"></i>
                        <?php
                        $mobile = isset($customer->mobile)?$customer->mobile:'';
                        if($mobile['0'] == 0) {
                            $mobile = substr($mobile,1);
                        }
                        $phonecode = isset($customer->phonecode)?$customer->phonecode:'';
                        echo (esc_html('+'.$phonecode . $mobile));
                        ?>
                    </p>
                    <p><i class="icon-nb-email"></i><?php esc_html_e($customer->email) ?></p>
                </div>
                <?php if($this->order->is_recurring == 0) {?>
                    <div class="date-recurring">
                        <i class="icon-nb-calendar"></i>
                        <div class="date-detail">
                            <div class="date-detail-item">
                                <span><?php echo (esc_html(HtmlFrontend::render_date($item->start_date,'Y-m-d')));?></span>
                            </div>
                        </div>
                    </div>
                    <div class="time-recurring">
                        <i class="icon-nb-clock"></i>
                        <div class="time-detail">
                            <div class="time-detail-item">
                                <span><?php echo (esc_html(HtmlFrontend::render_date($item->start_date,'H:i A')))?></span>
                                <span><?php echo (esc_html(HtmlFrontend::render_date($item->end_date,'H:i A')))?></span>
                            </div>
                        </div>
                    </div>
                <?php } else {?>
                    <div class="date-recurring">
                        <i class="icon-nb-calendar"></i>
                        <div class="date-detail">
                            <div class="date-detail-item">
                                <span><?php esc_html_e('From','wpbookingpro');?></span>
                                <span><?php echo (esc_html($rate_order->date_start_recurring));?></span>
                            </div>
                            <div class="date-detail-item">
                                <span><?php esc_html_e('To','wpbookingpro');?></span>
                                <span><?php echo (esc_html($rate_order->date_end_recurring));?></span>
                            </div>
                        </div>
                    </div>
                    <div class="time-recurring">
                        <i class="icon-nb-clock"></i>
                        <div class="time-detail">
                            <div class="time-detail-item">
                                <span><?php echo (esc_html($rate_order->time_start_recurring))?></span>
                                <span><?php echo (esc_html($rate_order->time_end_recurring))?></span>
                            </div>
                        </div>
                    </div>
                    <?php if($this->order->type_recurring == 'weekly' || $this->order->type_recurring == 'monthly') {?>
                        <div class="day-recurring">
                            <i class="fas fa-sun"></i>
                            <span>
                                <?php echo (implode(', ', array_map(
                                    function ($v) {
                                        return ucfirst($v);
                                    }, $day_recurring
                                ))); ?>
                            </span>
                        </div>
                    <?php }?>
                <?php }?>
            </div>
            <div class="price-quantity-total">
                <div class="price-detail price">
                    <span class="price-title"><?php esc_attr_e('Price','wpbookingpro'); ?></span>
                    <span class="price-price"><?php echo(HtmlFrontend::render_price($item->price)) ?></span>
                </div>
                <?php if($this->order->is_recurring == 0) {?>
                    <div class="price-detail quantity">
                        <span class="quantity-title"><?php esc_attr_e('Quantity','wpbookingpro'); ?></span>
                        <span class="quantity-quantity"><?php esc_html_e($item->quantity) ?></span>
                    </div>
                <?php } else {?>
                    <div class="price-detail quantity">
                        <span class="quantity-title"><?php esc_attr_e('Day recurring','wpbookingpro'); ?></span>
                        <span class="quantity-quantity"><?php esc_html_e($this->order->number_day_recurring) ?></span>
                    </div>
                <?php } ?>
                <div class="price-detail total">
                    <span><?php esc_attr_e('Total','wpbookingpro'); ?></span>
                    <span><?php echo(HtmlFrontend::render_price($item->total)) ?></span>
                </div>
            </div>
        </div>
    </div>
</div>
