<?php
namespace WpBookingProFrontend\app\views\payment;

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Wordpress\ECommerce\ECommerce;

class PaymentView extends View
{
    public $tour;
    public $first_name;
    public $last_name;
    public function display($tpl){
        $input=FactoryAlias::getInput();
        switch ($tpl) {
            case "paynow":
                $orderModel = Model::getInstance('order');
                $order_id = $input->getInt('order_id', 0);
                $this->order = $orderModel->getItem($order_id);
                $paymentModel = Model::getInstance('payment');
                $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->open_source_payment_id);
                $eCommerce = ECommerce::getInstance();
                $eCommerce->init();
                break;
            case "return":
                $orderModel = Model::getInstance('order');
                $order_id = $input->getInt('order_id', 0);
                $this->order = $orderModel->getItem($order_id);
                $paymentModel = Model::getInstance('payment');
                $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->open_source_payment_id);
                $eCommerce = ECommerce::getInstance();
                $eCommerce->my_change_status_function($this->order->open_source_order_id);
                break;
            case "cancel":
                $orderModel = Model::getInstance('order');
                $order_id = $input->getInt('order_id', 0);
                $this->order = $orderModel->getItem($order_id);
                $paymentModel = Model::getInstance('payment');
                $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->open_source_payment_id);
                $eCommerce = ECommerce::getInstance();
                $eCommerce->wc_cancel_unpaid_submitted($this->order->open_source_order_id);
                break;
            case "notify":
                $orderModel = Model::getInstance('order');
                $order_id = $input->getInt('order_id', 0);
                $this->order = $orderModel->getItem($order_id);
                $paymentModel = Model::getInstance('payment');
                $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->open_source_payment_id);
                break;
        }
        return parent::display($tpl);
    }



}