<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory as FactoryAlias;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Router\Route;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

class ServicesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "services";
    /**
     * @var string
     */
    public $table_name = "service";
    public function getListQuery()
    {
        $input=FactoryAlias::getInput();
        $data=$input->getData();
        $location_id=$input->getInt('location_id',0);
        $price_search=$input->getString('price_search',"");
        $near_me = $input->getInt('near_me',0);
        $latitude = $input->getFloat('latitude','');
        $longitude = $input->getFloat('longitude','');
        $appConfig = FactoryAlias::getAppConfig();
        $radius_for_search = $appConfig->get('radius_for_search', '');
        $unit_for_search = $appConfig->get('unit_for_search', '');

        if($price_search!==""){
            $price_search=(array)json_decode($price_search);
        }

        $category=[];
        if(array_key_exists('category_id',(array)$data)) {
            $category=$data['category_id'];
            if(!empty($category)){
                $category=(array)$category;
            }
        }

        $rating=[];
        if(array_key_exists('total_rating_avg',(array)$data)) {
            $rating=$data['total_rating_avg'];
            if(!empty($rating)){
                $rating=(array)$rating;
            }
        }

        $employee=[];
        if(array_key_exists('employee',(array)$data)) {
            $employee=$data['employee'];
            if(!empty($employee)){
                $employee=(array)$employee;
            }
        }

        $query=$this->db->getQuery(true);
        $query->select("DISTINCT a.*")
            ->from($this->getTableName("service").' AS a')
            ->leftJoin($this->getTableName('category') . ' AS category ON category.id=a.category_id')
            ->select('category.name as category_name')
            ->leftJoin($this->getTableName('location') . ' AS location ON location.id=a.location_id')
            ->select('location.name as location_name')
            ->where('a.published=1')
        ;
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));

        $keyword=$input->getString('keyword',"");
        if($keyword!==""){
            $query->where('a.name LIKE '.$query->quote("%$keyword%"));
        }
        $keyword_address = $input->getString('address','');
        if($keyword_address!==""){
            $query->where('location.name LIKE '.$query->quote("%$keyword_address%"));
        }

        if($location_id!=0){
            $query
                ->where('a.location_id='.(int)$location_id)
            ;
        }
        if($near_me == 1) {
            if($latitude != '' && $longitude != '') {
                $modelLocations = Model::getInstance('locations');
                $list_location = $modelLocations->getList();
                $query2= $this->_db->getQuery(true);

                foreach ($list_location as $location) {
                    $distance = static::getDistanceBetweenPointsNew($latitude, $longitude, $location->lat, $location->lang,$unit_for_search);
                    $query2->clear()
                        ->update($this->getTableName('service'). ' AS service')
                        ->set('service.distance='.(float)$distance)
                        ->where('service.location_id='.(int)$location->id)
                    ;
                    $this->db->setQuery($query2)->execute();
                }
                $query->where('a.distance <= '.(float)$radius_for_search);
            }
        }

        if(is_array($price_search) && !empty($price_search)){
            $min=reset($price_search);
            $max=end($price_search);

            $query->where('a.price>='.(float)$min);
            $query->where('a.price<='.(float)$max);
        }
        if(is_array($employee) && !empty($employee)){
            if ($_SERVER['REQUEST_METHOD'] === 'GET') {
                $query
                    ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                    ->where('service_employee.employee_id IN ('.$employee['0'].')')
                ;
            }elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $query
                    ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                    ->where('service_employee.employee_id IN ('.implode($employee,",").')')
                ;
            }
        }
        
        if(is_array($category) && !empty($category)){
            if ($_SERVER['REQUEST_METHOD'] === 'GET') {
                $query
                    ->where('a.category_id IN ('.$category['0'].')')
                ;
            }elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $query
                    ->where('a.category_id IN ('.implode($category,",").')')
                ;
            }
        }
        
        $key_sort_by="a.ordering";
        if(isset($data['sort']) && trim($data['sort'])!==''){
            $key_sort_by=$data['sort'];
        }
        $direction="";
        if(isset($data['direction']) && trim($data['direction'])!==''){
            $direction=$data['direction'];
        }
        $query->order("$key_sort_by $direction");

        // if(isset($data['total_rating_avg[]']) && $data['total_rating_avg']>0){
        //     $query->where('a.total_rating_avg='.(int)$data['total_rating_avg']);
        // }
        // $query->group('a.id');
        if(is_array($rating) && !empty($rating)){
            if ($_SERVER['REQUEST_METHOD'] === 'GET') {
                $query
                    ->where('a.total_rating_avg IN ('.$rating['0'].')')
                ;
            }elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $query
                    ->where('a.total_rating_avg IN ('.implode($rating,",").')')
                ;
            }
        }
        return $query;
    }
    public function getList()
    {
        $input=FactoryAlias::getInput();
        $uri = FactoryAlias::getUri();
        $data=$input->getData();
        $start=0;
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            $start=0;
        }elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if(isset($data['start']) && $data['start'] !== ''){
                $start = (int)$data['start'];
            }
        }
        $limit=6;
        if(isset($data['limit']) && $data['limit'] !== ''){
            $limit = (int)$data['limit'];
        }
        if(isset($data['total_item']) && $data['total_item'] !== ''){
            if( !empty($data['page']) > 1 ) {
                if( intval($data['total_item']) < $limit ) {
                    $limit = intval($data['total_item']);
                }
            }
        }
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query,$start,$limit)->loadObjectList();


        // $rating = isset($data['total_rating_avg'])?$data['total_rating_avg']:array();

        // if(count($rating)) {
        //     $rating = array_map(function ($v){
        //         return json_decode($v);
        //     },$rating);
        //     $rating = call_user_func_array("array_merge",$rating);
        // }

        foreach ($list_service as $key => &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $query->clear()
            ->select('wishlist.user_id')
            ->from(UtilityAlias::getTableName('wishlist').' AS wishlist')
            ->where('wishlist.service_id='.(int)$item->id)
            ;
            $item->user_wishlist = $db->setQuery($query)->loadColumn();

            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();
            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;

            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }

            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;

            $item->lang = reset($location)->lang;
            $item->lat = reset($location)->lat;
        }
        return $list_service;
    }
    public function get_list_service_loc()
    {
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        $input = FactoryAlias::getInput();
        $data = $input->getData();
        $rating = isset($data['rating'])?$data['rating']:'';
        if(is_array($rating) && count($rating)) {
            $rating = array_map(function ($v){
                return json_decode($v);
            },$rating);
            $rating = call_user_func_array("array_merge",$rating);
        } else {
            $rating = json_decode($rating);
        }
        
        foreach ($list_service as $key => &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:'';
            $query->clear()
                ->select('wishlist.id')
                ->from($this->getTableName('wishlist') . ' AS wishlist')
                ->where('wishlist.service_id=' . (int)$item->id)
                ->where('wishlist.user_id=' . (int)$user_id)
            ;

            $wishlist = $this->db->setQuery($query)->loadResult();
            $item->wishlist = $wishlist;
            
            $query->clear()
            ->select('wishlist.user_id')
            ->from(UtilityAlias::getTableName('wishlist').' AS wishlist')
            ->where('wishlist.service_id='.(int)$item->id)
            ;
            $item->user_wishlist = $db->setQuery($query)->loadColumn();


            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();
            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;
            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }

            if(!empty($rating)) {
                if($item->rating_avg < min($rating) || $item->rating_avg > max($rating)) {
                    unset($list_service[$key]);
                }
            }


            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;

            $item->lang = reset($location)->lang;
            $item->lat = reset($location)->lat;
        }


        return array_values($list_service);
    }

    public function getTotalRecord(){
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        return count($list_service);
    }

    public static function getDistanceBetweenPointsNew($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Mi') {
        $theta = (float)$longitude1 - (float)$longitude2;
        $distance = sin(deg2rad((float)$latitude1)) * sin(deg2rad((float)$latitude2)) + cos(deg2rad((float)$latitude1)) * cos(deg2rad((float)$latitude2)) * cos(deg2rad((float)$theta));

        $distance = acos($distance);
        $distance = rad2deg($distance);
        $distance = $distance * 60 * 1.1515;

        switch($unit)
        {
            case 'Mi': break;
            case 'Km' : $distance = $distance * 1.609344;
        }

        return (round($distance,2));
    }

    public function getListServicesAjax() {
        $input = Factory::getInput();
        $data = $input->getData();
        $page_service_detail = isset($data['page_service_detail']) ? $data['page_service_detail'] : "";
        $page_list_service = isset($data['page_list_service']) ? $data['page_list_service'] : "";
        $modelServices = Model::getInstance('services');
        $list_service = $modelServices->getList();
        $view_list_service = $this->htmlViewListService($list_service,$page_service_detail,$page_list_service);
        return $view_list_service;
    }
    public function htmlViewListService($list_service,$page_service_detail='',$page_list_service='') {
        $input = FactoryAlias::getInput();
        $template1 = $this->template1($list_service,$page_service_detail,$page_list_service);
        $template2 = $this->template2($list_service,$page_service_detail,$page_list_service);        
        $dataModel = array();
        $dataModel['template1'] = $template1;
        $dataModel['template2'] = $template2;
        $dataModel['total'] = $this->getTotalRecord();
        $dataModel['layout'] = $input->getString('tab', "grid");
        $dataModel['layoutlist'] = $input->getString('layout', "sidebar");
        return $dataModel;
    }
    public function template1($list_service,$page_service_detail='',$page_list_service='') {
        $input = FactoryAlias::getInput();
        $tab = $input->getString('tab', "grid");
        $sort = $input->getString('sort', 'a.ordering');
        $user_id = $input->getInt('user_id',0);
        $layout = $input ->getString('layout', "sidebar");

        $rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
        if($rating_avg > 0) {
            $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
        }
        ob_start();
        if (count((array)$list_service)> 0){
            foreach ($list_service as $key => $service) {
                if($layout =="sidebar"){ ?>
                    <div class="col-sm-12 col-md-6 col-lg-6">
                <?php } elseif($layout =="fullwidth") { ?>
                    <div class="col-sm-12 col-md-6 col-lg-4">
                <?php } ?>
                    <div class="service-item-table wishlist-item" data-service_id="<?php echo $service->id ?>" data-user_id="<?php echo  esc_attr($user_id) ?>">
                        <div class="wrapper-service-item">
                            <div class="img-block">
                                <a href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>">
                                    <img class="item-core-image" src="<?php echo esc_url(Factory::getRootUrlPlugin())?>/<?php echo esc_html($service->image) ?>" alt="item-core-image" />
                                    <div class="price">
                                        <p><span class="icon-tags"></span>$ <?php echo esc_html($service->price); ?></p>
                                    </div>
                                    <div class="rating">
                                        <ul class="list-rating-star ">
                                            <?php
                                            $rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
                                            if($rating_avg > 0) {
                                                $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
                                            }
                                            $list_review = isset($service->list_review)?$service->list_review:array();
                                            $input = Factory::getInput();
                                            $near_me=$input->getInt('near_me',0);
                                            $appConfig = Factory::getAppConfig();
                                            $unit_for_search = $appConfig->get('unit_for_search', '');
                                            $curent_user_id= isset(Factory::getUser()->id)?Factory::getUser()->id:'';
                                            $number_review=count($list_review);
                                            $total_rating_avg = 0;
                                            foreach ($list_review as $review){
                                                $total_rating_avg +=$rating_avg;
                                            }
                                            if($number_review>0){
                                                $rating_avg_avg = $total_rating_avg / $number_review;
                                            } else{
                                                $rating_avg_avg=0;
                                            }
                                            $list_star_sum = HtmlFrontend::get_rating_star($rating_avg_avg);
                                            ?>
                                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                    </div>
                                    <div class="label">
                                        <?php if($service->featured==1){?>
                                            <p class="featured"><?php esc_attr_e('FEATURED', 'retreatclub') ?></p>
                                        <?php } else if ($service->featured==0 && $service->popular==1){?>
                                            <p class="popular"><?php esc_attr_e('POPULAR', 'retreatclub') ?></p>
                                        <?php } else if($service->featured==0 && $service->popular==0 & $service->new==1 ){?>
                                            <p><?php esc_attr_e('NEW', 'retreatclub') ?></p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </a>
                            <div class="wrapper-content">
                                <div class="item-content">
                                    <h3 class="title-service">
                                        <a href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>">
                                            <?php echo esc_html($service->name); ?>
                                        </a>
                                    </h3>
                                    <div class="description">
                                        <?php
                                        $description=$service->description;
                                        if(strlen($description)>65){?>
                                            <p><?php echo esc_html(substr($description,0,65)) ?><?php esc_attr_e('...', 'retreatclub') ?></p>
                                        <?php } else { ?>
                                            <p><?php echo esc_html($description) ?></p>
                                        <?php }
                                        ?>
                                    </div>
                                </div>
                                <div class="wrapper-footer">
                                    <span>
                                        <i class="icon-pin-icon"></i>
                                         <?php echo esc_html($service->location_name); ?>
                                    </span>
                                    <a  href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>" class="nb-primary-button">
                                        <?php echo esc_html('Book Now','retreatclub'); ?>
                                    </a>
                                </div>
                                <div class="category-name-heart">
                                    <p><a href="<?php echo esc_url($this->page_list_service.'?category_id='.$service->category_id); ?>" class="category-name"><?php echo esc_html($service->category_name); ?></a></p>
                                    <input type="checkbox">
                                    <span class="heart <?php echo esc_attr((in_array($user_id,$service->user_wishlist) )?' active ':'') ?>">
                                        <i class="icon-heart3"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        return $content = ob_get_clean();
    }
    public function template2($list_service,$page_service_detail='',$page_list_service='') {
        $input = FactoryAlias::getInput();
        $tab = $input->getString('tab', "grid");
        $sort = $input->getString('sort', 'a.ordering');
        $user_id = $input->getInt('user_id',0);
        ob_start();
        if (count((array)$list_service)> 0){
            foreach ($list_service as $key => $service) {
            ?>
                <div class="view-list-layout-service2 view-list-service wishlist-item" data-service_id="<?php echo esc_attr($service->id) ?>" data-user_id="<?php echo (($this->user->id)) ?>">
                    <div class="service-item">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row row-config-0">
                                    <div class="col-lg-6 col-md-5 padd-config-0">
                                        <div class="wrapper-service-item">
                                            <div class="img-block">
                                                <a href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>">
                                                    <div class="item-core-image" style="background-image: url(<?php echo esc_url(Factory::getRootUrlPlugin())?>/<?php echo esc_html($service->image) ?>);">
                                                    </div>
                                                    <div class="price">
                                                        <p><span class="icon-tags"></span>$ <?php echo esc_html($service->price); ?></p>
                                                    </div>
                                                    <div class="rating">
                                                        <ul class="list-rating-star ">
                                                            <?php
                                                            $rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
                                                            if($rating_avg > 0) {
                                                                $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
                                                            }
                                                            $list_review = isset($service->list_review)?$service->list_review:array();
                                                            $input = Factory::getInput();
                                                            $near_me=$input->getInt('near_me',0);
                                                            $appConfig = Factory::getAppConfig();
                                                            $unit_for_search = $appConfig->get('unit_for_search', '');
                                                            $curent_user_id= isset(Factory::getUser()->id)?Factory::getUser()->id:'';
                                                            $number_review=count($list_review);
                                                            $total_rating_avg = 0;
                                                            foreach ($list_review as $review){
                                                                $total_rating_avg +=$rating_avg;
                                                            }
                                                            if($number_review>0){
                                                                $rating_avg_avg = $total_rating_avg / $number_review;
                                                            } else{
                                                                $rating_avg_avg=0;
                                                            }
                                                            $list_star_sum = HtmlFrontend::get_rating_star($rating_avg_avg);
                                                            ?>
                                                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                                            <?php }?>
                                                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                            <?php }?>
                                                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                                <li class="item-star"><i class="far fa-star"></i></li>
                                                            <?php }?>
                                                        </ul>
                                                    </div>
                                                    <div class="label">
                                                        <?php if($service->featured==1){?>
                                                            <p class="featured"><?php esc_attr_e('FEATURED', 'retreatclub') ?></p>
                                                        <?php } else if ($service->featured==0 && $service->popular==1){?>
                                                            <p class="popular"><?php esc_attr_e('POPULAR', 'retreatclub') ?></p>
                                                        <?php } else if($service->featured==0 && $service->popular==0 & $service->new==1 ){?>
                                                            <p><?php esc_attr_e('NEW', 'retreatclub') ?></p>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-7 padd-config-0">
                                        <div class="wrapper-service-item">
                                            <div class="wrapper-content">
                                                <div class="item-content">
                                                    <h3 class="title-service">
                                                        <a href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>">
                                                            <?php echo esc_html($service->name); ?>
                                                        </a>
                                                    </h3>
                                                    <div class="description">
                                                        <?php
                                                        $description=$service->description;
                                                        if(strlen($description)>65){?>
                                                            <p><?php echo esc_html(substr($description,0,65)) ?><?php esc_attr_e('...', 'retreatclub') ?></p>
                                                        <?php } else { ?>
                                                            <p><?php echo esc_html($description) ?></p>
                                                        <?php }
                                                        ?>
                                                    </div>
                                                </div>
                                                <div class="wrapper-footer">
                                                            <span>
                                                                <i class="icon-pin-icon"></i>
                                                                 <?php echo esc_html($service->location_name); ?>
                                                            </span>
                                                    <a  href="<?php echo esc_url(Route::_($page_service_detail.'?service_id='.$service->id)); ?>" class="nb-primary-button">
                                                        <?php echo esc_html('Book Now','retreatclub'); ?>
                                                    </a>
                                                </div>
                                                <div class="category-name-heart">
                                                    <p><a href="<?php echo esc_url($this->page_list_service.'?category_id='.$service->category_id); ?>" class="category-name"><?php echo esc_html($service->category_name); ?></a></p>
                                                    <input type="checkbox">
                                                    <span class="heart <?php echo ((in_array($user_id,$service->user_wishlist) )?' active ':'') ?>">
                                                        <i class="icon-heart3"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }   
        }
        return $content = ob_get_clean();
    }
}
