<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory as FactoryAlias;

use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProFrontend\app\helpers\FrontendHelper;

class Servicelocator extends ModelList
{
    /**
     * @var string
     */
    public $context = "services";
    /**
     * @var string
     */
    public $table_name = "service";
    public function getListQuery()
    {
        $input=FactoryAlias::getInput();
        $data=$input->getData();
        $location_id=$input->getInt('location',0);
        $price_search=$input->getString('price_search',"");
        $near_me = $input->getInt('near_me',0);
        $latitude = $input->getFloat('latitude','');
        $longitude = $input->getFloat('longitude','');
        $appConfig = FactoryAlias::getAppConfig();
        $radius_for_search = $appConfig->get('radius_for_search', '');
        $unit_for_search = $appConfig->get('unit_for_search', '');
        if($price_search!==""){
            $price_search=(array)json_decode($price_search);
        }
        $category=[];
        if(array_key_exists('category',(array)$data)) {
            $category=$data['category'];
            if(!empty($category)){
                $category=(array)$category;
            }
        }
        $employee=[];
        if(array_key_exists('employee',(array)$data)) {
            $employee=$data['employee'];
            if(!empty($employee)){
                $employee=(array)$employee;
            }
        }

        $query=$this->db->getQuery(true);
        $query->select("DISTINCT a.*")
            ->from($this->getTableName("service").' AS a')
            ->where('a.published=1')
        ;
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));

        if($location_id!=0){
            $query
                ->where('a.location_id='.(int)$location_id)
            ;
        }
        if($near_me == 1) {
            if($latitude != '' && $longitude != '') {
                $modelLocations = Model::getInstance('locations');
                $list_location = $modelLocations->getList();
                $query2= $this->_db->getQuery(true);

                foreach ($list_location as $location) {
                    $distance = static::getDistanceBetweenPointsNew($latitude, $longitude, $location->lat, $location->lang,$unit_for_search);
                    $query2->clear()
                        ->update($this->getTableName('service'). ' AS service')
                        ->set('service.distance='.(float)$distance)
                        ->where('service.location_id='.(int)$location->id)
                    ;
                    $this->db->setQuery($query2)->execute();
                }
                $query->where('a.distance <= '.(float)$radius_for_search);
            }
        }

        if(is_array($price_search) && !empty($price_search)){
            $min=reset($price_search);
            $max=end($price_search);

            $query->where('a.price>='.(float)$min);
            $query->where('a.price<='.(float)$max);
        }
        if(is_array($employee) && !empty($employee)){

            $query
                ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                ->where('service_employee.employee_id IN ('.implode($employee,",").')')
            ;
        }
        if(is_array($category) && !empty($category)){

            $query
                ->where('a.category_id IN ('.implode($category,",").')')
            ;
        }
        $query->group('a.id');
        return $query;
    }
    public function getList()
    {
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        foreach ($list_service as &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();
            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;
            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }


            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
        }
        return $list_service;
    }


    public static function getDistanceBetweenPointsNew($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Mi') {
        $theta = (float)$longitude1 - (float)$longitude2;
        $distance = sin(deg2rad((float)$latitude1)) * sin(deg2rad((float)$latitude2)) + cos(deg2rad((float)$latitude1)) * cos(deg2rad((float)$latitude2)) * cos(deg2rad((float)$theta));

        $distance = acos($distance);
        $distance = rad2deg($distance);
        $distance = $distance * 60 * 1.1515;

        switch($unit)
        {
            case 'Mi': break;
            case 'Km' : $distance = $distance * 1.609344;
        }

        return (round($distance,2));
    }

}
