<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;

class ReviewModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "review";
    /**
     * @var string
     */
    public $table_name = "review";


    public function save_review($data = array())
    {
        $input=Factory::getInput();
        $data=$input->getData();
        $db=Factory::getDBO();
        $name=$data['name'];
        $email=$data['email'];
        $comment= $data['comments'];
        $rating_ambience=$data['rating_ambience'];
        $rating_cleanliness=$data['rating_cleanliness'];
        $rating_staff= $data['rating_staff'];
        $rating_value = $data['rating_value'];
        $created_date = Factory::getDate();
        $service_id = isset($data['service_id'])?$data['service_id']:0;
        $modalReview= Model::getInstance('review');
        $data_review=[
            "name" =>$name,
            "email" =>$email,
            "service_id"=> $service_id,
            "created_date"=>$created_date->toSql(),
            "comments" =>$comment,
            "rating_value"=>$rating_value,
            "rating_ambience" =>$rating_ambience,
            "rating_cleanliness"=>$rating_cleanliness,
            "rating_staff" =>$rating_staff,
            "published" =>1
       ];
        $review = $modalReview->save($data_review);
        $query = $db->getQuery(true);
        $query->select('review.*')
            ->from($this->getTableName('review') . ' AS review')
            ->where('review.service_id=' . (int)$service_id);
        $list_reviews = $db->setQuery($query)->loadObjectList();
        $number_review=count($list_reviews) +1;
        $sum_rating=0;
        foreach ($list_reviews as &$review){
            $sum_rating +=($review->rating_ambience + $review->rating_cleanliness + $review->rating_staff + $review->rating_value);
        }
        $total_rating_after_add=$sum_rating +$rating_ambience + $rating_cleanliness +$rating_staff + $rating_value;
        $total_rating_after_add_avg=round($total_rating_after_add/(4*$number_review));
        $query->clear()
            ->update($this->getTableName('service').' AS service')
            ->where('service.id='.(int)$service_id)
            ->set('total_rating_avg='.(int)$total_rating_after_add_avg)
        ;
        $db->setQuery($query)->execute();
        $query->clear()
            ->insert($this->getTableName('service_review'))
            ->set('review_id='.(int)($review->id))
            ->set('service_id='.(int)$service_id)
        ;
        $db->setQuery($query)->execute();
        return $review;

    }

}
