<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class EmployeesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "employees";
    /**
     * @var string
     */
    public $table_name = "employee";


    public function getList()
    {
        $list = parent::getList(); // TODO: Change the autogenerated stub
        foreach ($list as &$item) {
            $item->full_name = $item->first_name.' '.$item->last_name;
            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
            $query = $this->db->getQuery(true);
            $query->select('service_employee.employee_id AS employee_id, service_employee.service_id AS service_id')
                ->from($this->getTableName('service_employee') . ' AS service_employee')
                ->leftJoin($this->getTableName('service') . ' AS service ON service.id=service_employee.service_id')
                ->leftJoin($this->getTableName('category') . ' AS category ON category.id=service.category_id')
                ->select('category.*')
                ->group('service_employee.employee_id')
                ->having('service_employee.employee_id=' . (int)$item->id);
            $item->category = $this->db->setQuery($query)->loadObjectList();
        }
        return $list;
    }

}
