<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility as UtilityAlias;

class CountriesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "countries";
    /**
     * @var string
     */
    public $table_name = "country";
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        return $db->setQuery($query)->loadObjectList();
    }
    public static function getList_location(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('country.countryname')
            ->from(UtilityAlias::getTableName('country').' AS country ')
            ->leftJoin(UtilityAlias::getTableName('state').' AS state ON state.country_id=country.id')
            ->select('state.id AS state_id')
            ->where('country.id=state.country_id')
        ;

        $list_country=$db->setQuery($query)->loadObjectList();
        foreach ($list_country as &$country) {
            $query->clear()
                ->select('location.name AS location_name, location.id AS location_id')
                ->from(UtilityAlias::getTableName('location').' AS location')
                ->where('location.state_id='.(int)$country->state_id)
            ;
            $list_location = $db->setQuery($query)->loadObjectList();
            $country->list_location = $list_location;
        }
        return $list_country;
    }


}
