<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class CategoriesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "categories";
    /**
     * @var string
     */
    public $table_name = "category";

    public function getListQuery()
    {

        $query=$this->db->getQuery(true);
        $query->select("a.*")
            ->from($this->getTableName().' AS a')
            ->where('a.published=1')

        ;
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));

        return $query;
    }

    public function getList()
    {
        $list = parent::getList(); // TODO: Change the autogenerated stub
        $query = $this->db->getQuery(true);
        foreach ($list as &$item) {
            $query->clear()
                ->select('service.*')
                ->from($this->getTableName('service') . ' AS service')
                ->where('service.category_id=' . (int)$item->id)
                ->where('service.published=1')
            ;
            $item->list_service = $this->_db->setQuery($query)->loadObjectList();
        }
        return $list;
    }
}
