<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProFrontend\app\helpers\SmsHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;
use Twilio\Rest\Client;

class BookingModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "booking";
    /**
     * @var string
     */
    public $table_name = "booking";
    public function book_service($data)
    {
        $employee_id = isset($data['employee_id'])?$data['employee_id']:0;
        $event_id = isset($data['event_id'])?$data['event_id']:0;
        $number_person = isset($data['number_person'])?$data['number_person']:1;
        $first_name = isset($data['first_name'])?$data['first_name']:'';
        $last_name = isset($data['last_name'])?$data['last_name']:'';
        $email = isset($data['email'])?$data['email']:'';
        $phonecode = isset($data['phonecode'])?$data['phonecode']:'';
        $countrycode = isset($data['countrycode'])?$data['countrycode']:'';
        $phone = isset($data['phone'])?$data['phone']:'';
        $is_recurring = isset($data['is_recurring'])?$data['is_recurring']:0;
        $type_recurring = isset($data['type_recurring'])?$data['type_recurring']:0;
        $day_of_week = isset($data['day_of_week'])?$data['day_of_week']:array();
        $number_week_recurring = isset($data['number_week_recurring'])?$data['number_week_recurring']:0;
        $number_month_recurring = isset($data['number_month_recurring'])?$data['number_month_recurring']:0;
        $date_start_recurring = isset($data['date_start_recurring'])?$data['date_start_recurring']:'';
        $time_start_recurring = isset($data['time_start_recurring'])?$data['time_start_recurring']:'';
        $date_end_recurring = isset($data['date_end_recurring'])?$data['date_end_recurring']:'';
        $time_end_recurring = isset($data['time_end_recurring'])?$data['time_end_recurring']:'';

        if($phone['0'] == '0') {
            $phone = substr($phone, 1);
        }
        $payment_id = isset($data['open_source_payment_id'])?$data['open_source_payment_id']:'';
        $created_date = Factory::getDate();

        $customerModel = Model::getInstance('customer');
        $data_customer = [
            "first_name" => $first_name,
            "last_name" => $last_name,
            "phonecode"=>$phonecode,
            "countrycode"=>$countrycode,
            "mobile" => $phone,
            "email" => $email,
            "address_1"=>isset($data['address_1'])?$data['address_1']:'',
            "address_2"=>isset($data['address_2'])?$data['address_2']:'',
            "city"=>isset($data['city'])?$data['city']:'',

        ];
        $customer = $customerModel->save($data_customer);



        $event=array();
        if($event_id > 0) {
            $eventModel = Model::getInstance('event');
            $event = $eventModel->getItem($event_id);
        }

        $service_id = $data['service_id'];
        $serviceModel = Model::getInstance('service');
        $service = $serviceModel->getItem($service_id);
        $list_employee = $service->list_employee;
        foreach ($list_employee as $key => $employee_item) {
            if($employee_item->id != $employee_id) {
                unset($list_employee[$key]);
            }
        }

        $paymentModel = Model::getInstance('payment');
        $payment = $paymentModel->getItem($payment_id);
        $start_date = isset($data['calendar'])?$data['calendar']:'';
        $time_start_not_recurring = explode(' ', $start_date);
        $time_start_not_recurring = end($time_start_not_recurring);
        $newtimestamp = strtotime($start_date.'+'. ($service->duration * 60).' minutes');
        $end_date = date('Y-m-d H:i:s', $newtimestamp);
        $multiply_number = $service->multiply_number;
        $quantity = $number_person;
        $start_recurring = strtotime($date_start_recurring);
        $end_recurring = strtotime($date_end_recurring);
        $number_day_recurring = 0;
        if($type_recurring == 'weekly' || $type_recurring == 'monthly') {
            while($start_recurring <= $end_recurring) {
                $day = date('l', $start_recurring);
                if(in_array(strtolower($day),$day_of_week)) {
                    $number_day_recurring++;
                }
                $start_recurring = strtotime("+1 day", $start_recurring);
            }
        } elseif($type_recurring == 'daily') {
            while($start_recurring <= $end_recurring) {
                $number_day_recurring++;
                $start_recurring = strtotime("+1 day", $start_recurring);
            }
        }
        if($is_recurring) {
            if ($multiply_number == 1) {
                if($event) {
                    $price = $event->price;
                    $total = (int)$number_person * $event->price * $number_day_recurring;
                } else {
                    $price = $service->price;
                    $total = (int)$number_person * $service->price * $number_day_recurring;
                }
                foreach ($list_employee as $employee) {
                    if(strtotime($time_start_recurring) >= strtotime($employee->start_time) && strtotime($time_start_recurring) <= strtotime($employee->end_time)) {
                        $price = $employee->price;
                        $total = (int)$number_person * $employee->price * $number_day_recurring;
                    }
                }


            } else {
                if($event) {
                    $price = $event->price;
                    $total = $event->price * $number_day_recurring;
                } else {
                    $price = $service->price;
                    $total = $service->price * $number_day_recurring;
                }
                foreach ($list_employee as $employee) {
                    if(strtotime($time_start_recurring) >= strtotime($employee->start_time) && strtotime($time_start_recurring) <= strtotime($employee->end_time)) {
                        $price = $employee->price;
                        $total = $employee->price * $number_day_recurring;
                    }
                }

            }
        } else {
            if ($multiply_number == 1) {
                if($event) {
                    $price = $event->price;
                    $total = (int)$number_person * $event->price;
                } else {
                    $price = $service->price;
                    $total = (int)$number_person * $service->price ;
                }
                foreach ($list_employee as $employee) {
                    if(strtotime($time_start_not_recurring) >= strtotime($employee->start_time) && strtotime($time_start_not_recurring) <= strtotime($employee->end_time)) {
                        $price = $employee->price;
                        $total = (int)$number_person * $employee->price ;
                    }
                }

            } else {
                if($event) {
                    $price = $event->price;
                    $total = $event->price;
                } else {
                    $price = $service->price;
                    $total = $service->price;
                }
                foreach ($list_employee as $employee) {
                    if(strtotime($time_start_not_recurring) >= strtotime($employee->start_time) && strtotime($time_start_not_recurring) <= strtotime($employee->end_time)) {
                        $price = $employee->price;
                        $total = $employee->price;
                    }
                }

            }
        }

        $orderModel = Model::getInstance('order');
        $data_order = [
            "customer_id" => $customer->id,
            "open_source_payment_id" => $payment_id,
            "total" => $total,
            "type" => $event?AdminHelper::getWpBookingEventKey():AdminHelper::getWpBookingServiceKey(),
            "created_date"=>isset($data['create_date'])?$data['create_date']:$created_date->toSql(),
            "open_source_order_id"=>isset($data['open_source_order_id'])?$data['open_source_order_id']:'',
            "open_source_order_status_id"=>isset($data['open_source_order_status_id'])?$data['open_source_order_status_id']:'',
            "is_recurring"=>$is_recurring,
            "type_recurring"=>$type_recurring,
            "number_month_recurring"=>$number_month_recurring,
            "number_week_recurring"=>$number_week_recurring
        ];
        $order = $orderModel->save($data_order);
        if($is_recurring) {
            $orderDayRecurringModel = Model::getInstance('orderdayrecurring');
            $dataOrderDayRecurring = [
                "order_id"=>$order->id,
                "monday"=> in_array('monday', $day_of_week)?1:0,
                "tuesday"=>in_array('tuesday', $day_of_week)?1:0,
                "wednesday"=>in_array('wednesday', $day_of_week)?1:0,
                "thursday"=>in_array('thursday', $day_of_week)?1:0,
                "friday"=>in_array('friday', $day_of_week)?1:0,
                "saturday"=>in_array('saturday', $day_of_week)?1:0,
                "sunday"=>in_array('sunday', $day_of_week)?1:0,
            ];
            $orderDayRecurring = $orderDayRecurringModel->save($dataOrderDayRecurring);
        }

        $orderDetailModel = Model::getInstance('orderdetail');
        $data_order_detail = [
            "id" => 0,
            "order_id" => $order->id,
            "quantity" => $quantity,
            "total" => $total,
            "employee_id" => $employee_id,
            "service_id" => $service_id,
            "location_id" => $event?$event->location_id:$service->location_id,
            "price" => $price
        ];
        $oder_detail = $orderDetailModel->save($data_order_detail);
        $orderDetailRateModel = Model::getInstance('orderdetailrate');
        $data_order_detail_rate = [
            "id" => 0,
            "order_detail_id" => $oder_detail->id,
            "start_date" => $start_date,
            "end_date" => $end_date,
            "employee_id" => $employee_id,
            "service_id" => $service_id,
            "location_id" => $event?$event->location_id:$service->location_id,
            "total" => $total,
            "price" => $price,
            "subtotal" => $total,
            "quantity" => $quantity,
            "date_start_recurring"=>$date_start_recurring,
            "time_start_recurring"=>$time_start_recurring,
            "date_end_recurring"=>$date_end_recurring,
            "time_end_recurring"=>$time_end_recurring,
        ];
        $order_detail_rate = $orderDetailRateModel->save($data_order_detail_rate);
        return $order;
    }
    public function add_google_calendar($oder_id){

        $client = self::getClient($oder_id);
        $service = new \Google_Service_Calendar($client);
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->getItem($oder_id);
        $appConfig = Factory::getAppConfig();
        $timezone = $appConfig->get('timezone','');
        $rate = isset($order->list_rate)?reset($order->list_rate):array();
        $customer = isset($order->customer)?reset($order->customer):array();
        if($order->is_recurring == 0) {
            $start = new \DateTime($rate->start_date, new \DateTimeZone($timezone));
            $end = new \DateTime($rate->end_date, new \DateTimeZone($timezone));
            $recurrence = array('RRULE:FREQ=DAILY;COUNT=1');
        } else {
            $start = new \DateTime($rate->date_start_recurring.' '.$rate->time_start_recurring, new \DateTimeZone($timezone));
            $end = new \DateTime($rate->date_start_recurring.' '.$rate->time_end_recurring, new \DateTimeZone($timezone));
            if($order->type_recurring === 'daily') {
                $recurrence = array('RRULE:FREQ=DAILY;COUNT='.$order->number_day_recurring);
            } elseif ($order->type_recurring === 'weekly') {
                $order_day_recurring = isset($order->order_day_recurring)?$order->order_day_recurring:array();
                $byday = implode(',', array_map(
                    function ($v) {
                        return strtoupper(substr($v,0,2));
                    },$order_day_recurring
                ));
                $recurrence = array('RRULE:FREQ=WEEKLY;COUNT='.$order->number_day_recurring.';BYDAY='.$byday);
            }elseif ($order->type_recurring === 'monthly') {
                $order_day_recurring = isset($order->order_day_recurring)?$order->order_day_recurring:array();
                $byday = implode(',', array_map(
                    function ($v) {
                        return strtoupper(substr($v,0,2));
                    },$order_day_recurring
                ));
                $recurrence = array('RRULE:FREQ=WEEKLY;COUNT='.$order->number_day_recurring.';BYDAY='.$byday);
            }
        }

        $expert = $rate->employee_fullname;
        $duration = $rate->duration;
        $description = $rate->service_description;

        $event = new \Google_Service_Calendar_Event(array(
            'summary' => $rate->service_name.' '.$oder_id,
            'location' => $rate->location_address,
            'description' =>"'Expert': $expert \n'Duration': $duration \n'Description': $description",
            'start' => array(
                'dateTime' => $start->format('c'),
                'timeZone' => $timezone
            ),
            'end' => array(
                'dateTime' => $end->format('c'),
                'timeZone' => $timezone
            ),
            'recurrence' => $recurrence,
            'attendees' => array(
                array('email' => $customer->email),
            ),
            'reminders' => array(
                'useDefault' => false,
                'overrides' => array(
                    array('method' => 'email', 'minutes' => 24 * 60),
                    array('method' => 'popup', 'minutes' => 10),
                ),
            ),
        ));
        $calendarId = 'primary';
        $event = $service->events->insert($calendarId, $event);


    }

    function getClient($oder_id)
    {

        $client = new \Google_Client();
        $client->setScopes(\Google_Service_Calendar::CALENDAR);

        $appConfig = Factory::getAppConfig();
        $file_client_secret = $appConfig->get('client_secret_file','');
        if(isset($file_client_secret) && trim($file_client_secret) !== '' && file_exists(WPBOOKINGPRO_PATH_ROOT.DS.$file_client_secret)) {
            $client->setAuthConfig(WPBOOKINGPRO_PATH_ROOT.DS.$file_client_secret);
        } else {
            throw new \Exception("error");
        }

        if(isset($_SESSION['access_token']) && is_array($_SESSION['access_token'])){
            //save event
            $client->setAccessToken($_SESSION['access_token']);

        }else{
            $auth=$client->createAuthUrl();
            $_SESSION['current_oder_id']=$oder_id;
            header("location:$auth");
            die;
        }
        return $client;
    }

    public function send_sms_after_booking($order_id) {
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->getItem($order_id);
        $sms = SmsHelper::get_sms_info_booking();
        $phone_sms = isset($sms->phone_register)?$sms->phone_register:'';
        $phonecode_sms = isset($sms->phonecode)?$sms->phonecode:'';
        if($phone_sms['0'] == '0') {
            $phone_sms = substr($phone_sms,1);
        }
        $suplier_phone = "+$phonecode_sms$phone_sms";
        $content = $sms->content_sms;
        $modelOrderDetail = Model::getInstance('orderdetail');
        $orderDetail = $modelOrderDetail->getItem(reset($order->list_order_detail)->id);
        $orderDetailRate = reset($order->list_rate);

        $modelService = Model::getInstance('service');
        $service = $modelService->getItem($orderDetail->service_id);

        $customer = reset($order->customer);
        $phone_customer = isset($customer->mobile)?$customer->mobile:'';
        $phonecode_customer = isset($customer->phonecode)?$customer->phonecode:'';
        if($phone_customer['0'] == '0') {
            $phone_customer = substr($phone_customer, 1);
        }
        $phone_customer_apply = "+$phonecode_customer$phone_customer";

        

        foreach ($service as $key => $value) {
            if (is_string($value))
                $content = str_replace("{service_$key}", $value, $content);
        }
        foreach ($order as $key => $value) {
            if (is_string($value))
                $content = str_replace("{order_$key}", $value, $content);
        }
        foreach ($orderDetail as $key => $value) {
            if (is_string($value))
                $content = str_replace("{orderdetail_$key}", $value, $content);
        }
        foreach ($orderDetailRate as $key => $value) {
            if (is_string($value))
                $content = str_replace("{orderdetailrate_$key}", $value, $content);
        }
        foreach ($customer as $key => $value) {
            if (is_string($value))
                $content = str_replace("{customer_$key}", $value, $content);
        }
        $content = str_replace('{location_i}', reset($order->list_rate)->location_address, $content);

        $sid = $sms->account_id;
        $token = $sms->auth_token;
        $client = new Client($sid, $token);

        $client->messages->create(
            $phone_customer_apply,
            [
                'from' => $suplier_phone,
                'body' => $content
            ]
        );
    }


}
