'use strict';
(function ($) {
    $.field_ratingstar = function (element, options) {
        var defaults = {
            field_name_rating_ambience:'',
            field_name_rating_cleanliness:'',
            field_name_rating_staff:'',
            field_name_rating_value:'',
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name_rating_ambience = plugin.settings.field_name_rating_ambience;
            let field_name_rating_cleanliness = plugin.settings.field_name_rating_cleanliness;
            let field_name_rating_staff = plugin.settings.field_name_rating_staff;
            let field_name_rating_value = plugin.settings.field_name_rating_value;
            $element.find('#stars li').on('mouseover', function(){
                var onStar = parseInt($(this).data('value'), 10);
                $(this).parent().children('li.star').each(function(e){
                    if (e < onStar) {
                        $(this).addClass('hover');
                    }
                    else {
                        $(this).removeClass('hover');
                    }
                });

            }).on('mouseout', function(){
                $(this).parent().children('li.star').each(function(e){
                    $(this).removeClass('hover');
                });
            });
            $element.find('#stars li').on('click', function(){
                var onStar = parseInt($(this).data('value'), 10);
                var stars = $(this).parent().children('li.star');
                var $rating_stars= $(this).closest('.rating-stars');

                for (let i = 0; i < stars.length; i++) {
                    $(stars[i]).removeClass('selected');
                    $(stars[i]).find('i').removeClass('fas');
                    $(stars[i]).find('i').addClass('far');
                }

                for (let i = 0; i < onStar; i++) {
                    $(stars[i]).addClass('selected');
                    $(stars[i]).find('i').removeClass('far');
                    $(stars[i]).find('i').addClass('fas');
                }

                var ratingValue = parseInt($('#stars li.selected').last().data('value'), 10);
                if($rating_stars.hasClass('ambience')) {
                    $element.find(`input[name="${field_name_rating_ambience['0']}"]`).val(ratingValue);
                } else if ($rating_stars.hasClass('cleanliness')) {
                    $element.find(`input[name="${field_name_rating_cleanliness['0']}"]`).val(ratingValue);
                } else if ($rating_stars.hasClass('staff')) {
                    $element.find(`input[name="${field_name_rating_staff['0']}"]`).val(ratingValue);
                } else if ($rating_stars.hasClass('value')) {
                    $element.find(`input[name="${field_name_rating_value['0']}"]`).val(ratingValue);
                }


            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_ratingstar = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_ratingstar')) {
                var plugin = new $.field_ratingstar(this, options);
                $(this).data('field_ratingstar', plugin);
            }
        });
    }
})(jQuery);