<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
	$item->id = $item->countrycode;
	$item->text = $item->countryname;
}
$data = $displayData['field']->getForm()->getData();
$country_code = $data->def('country_code', $default_country_code);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input type="text" class="countries" name="<?php esc_attr_e($field_name_country_code) ?>" value="<?php esc_attr_e($country_code) ?>" >
            <input type="text" class="phone_number" name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>" placeholder="<?php esc_attr_e($hint)?>">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/phonenumber1/phonenumber1.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
),'frontend/app/layouts/WooBooking/form/field/phonenumber1/phonenumber1.jquery.js');