<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelemployees = Model::getInstance('employees');
$list = $modelemployees->getList();
$list_time = [];
$list_employee_id = [];
if (!is_array($value)) {
    $list_employee_id[] = $value;
} else {
    $list_employee_id = $value;
}
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-countries">
        <select name="<?php esc_attr_e($name); ?>"  <?php echo($multiple ? ' multiple ' : null); ?>class="list-country">
            <option value=""><?php esc_attr_e('Select Employees','wpbookingpro') ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->id, $list_employee_id) ? ' selected ' : null) ?>value="<?php esc_attr_e($item->id); ?>"><?php esc_html_e($item->full_name); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/employees/employees.less');
$doc->addScriptApplySelector('.field-countries','field_countries',array(
),'frontend/app/layouts/WooBooking/form/field/employees/employees.jquery.js');