"use strict";
(function ($) {
    $.field_employeeimageslider = function (element, options) {
        var defaults = {
            field_name: 0
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            setTimeout(function () {
                $element.find('.list-employee').slick({
                    infinite: false,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    prevArrow: ".left-direction",
                    nextArrow: ".right-direction",
                    responsive: [
                          {
                            breakpoint: 992,
                            settings: {
                                arrows: true,
                                slidesToShow: 3,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                arrows: true,
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                arrows: true,
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        }
                    ]
                });

            },10);
            $element.find('.list-employee').on('breakpoint', function(event, slick, breakpoint) {
                $element.find('.wrapper-employee').click(function (e) {
                    let $self = $(this);
                    $element.find('.wrapper-employee').removeClass('active');
                    let employee_id = $self.data('employee_id');
                    $self.find('.selected').show();
                    $self.addClass('active');
                    $element.find(`input[name="${field_name}"]`).val(employee_id).trigger('change');
                });
            });
            $element.find('.wrapper-employee').on('click',function (e) {
                let $self = $(this);
                $element.find('.wrapper-employee').removeClass('active');
                let employee_id = $self.data('employee_id');
                $self.find('.selected').show();
                $self.addClass('active');
                $element.find(`input[name="${field_name}"]`).val(employee_id).trigger('change');
            });
        };
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`input[name="${field_name}"]`).val();
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_employeeimageslider = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_employeeimageslider')) {
                var plugin = new $.field_employeeimageslider(this, options);
                $(this).data('field_employeeimageslider', plugin);
            }
        });
    }
})(jQuery);
