<?php
namespace WpBookingProFrontend\app\helpers;

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;

class FrontendHelper
{

    public static function format_currency($cost = 0, $currency = "$")
    {
        return "$currency $cost";
    }
    public static function get_order_appointment_from_order_woocommerce($order_woo) {
        $db= Factory::getDBO();
        $query = $db->getQuery(true);
        $query->select('wborder.id')
            ->from(Utility::getTableName('order').' AS wborder')
            ->where('wborder.open_source_order_id='.(int)$order_woo)
            ;
        $order_id = $db->setQuery($query)->loadResult();
        return $order_id;
    }
    public static function write_log($log) {
        if (true === WP_DEBUG) {
            if (is_array($log) || is_object($log)) {
                error_log(print_r($log, true));
            } else {
                error_log($log);
            }
        }
    }
    public static function getDateOfWeekDayInMonth($date_start, $date_end, $day_of_week=array()) {
        $date_recurring = array();
        if(!empty($day_of_week)) {
            foreach ($day_of_week as $day) {
                switch ($day) {
                    case "monday":
                        $date_recurring["monday"] = self::getDayOfWeekInRange($date_start, $date_end, 'monday');
                        break;
                    case "tuesday":
                        $date_recurring["tuesday"] = self::getDayOfWeekInRange($date_start, $date_end, 'tuesday');
                        break;
                    case "wednesday":
                        $date_recurring["wednesday"] = self::getDayOfWeekInRange($date_start, $date_end, 'wednesday');
                        break;
                    case "thursday":
                        $date_recurring["thursday"] = self::getDayOfWeekInRange($date_start, $date_end, 'thursday');
                        break;
                    case "friday":
                        $date_recurring["friday"] = self::getDayOfWeekInRange($date_start, $date_end, 'friday');
                        break;
                    case "saturday":
                        $date_recurring["saturday"] = self::getDayOfWeekInRange($date_start, $date_end, 'saturday');
                        break;
                    case "sunday":
                        $date_recurring["sunday"] = self::getDayOfWeekInRange($date_start, $date_end, 'sunday');
                        break;
                }
            }
        } else {
            return $date_recurring;
        }
        return  $date_recurring;

    }
    public static function getDayOfWeekInRange($dateFromString, $dateToString, $day='')
    {
        $dateFrom = new \DateTime($dateFromString);
        $dateTo = new \DateTime($dateToString);
        $dates = [];

        if ($dateFrom > $dateTo) {
            return $dates;
        }

        if (1 != $dateFrom->format('W')) {
            $dateFrom->modify('next '.$day);
        }

        while ($dateFrom <= $dateTo) {
            $dates[] = $dateFrom->format('Y-m-d');
            $dateFrom->modify('+1 week');
        }

        return $dates;
    }
}