<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\Html\HtmlFrontend;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class ServicesController extends ControllerFrontend
{
    public function ajax_get_list_service()
    {
        if(!function_exists('wp_get_current_user')) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        $input = Factory::getInput();
        $data = $input->getData();
        foreach ($data as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            }
        }
        $modelServices=Model::getInstance('services');
        $list=$modelServices->get_list_service_loc();
        $user_id = $input->getInt("user_id",0);
        foreach ($list as $item){
             $item->link= Factory::getRootUrl()."/service-detail/".$item->alias.'-'.$item->id;
             $item->linkCategory= Factory::getRootUrl()."/services-list/?category_id=".$item->category_id;
             $item->lng=$item->lang;
             $item->address="12509 Wayzata Blvd";
             $item->address2="";
             $item->decs= mb_strimwidth($item->description, 0, 100, "...");
             $item->city=$item->location->address;
             $item->ctg=$item->category->name;
             $item->state="MN";
             $item->postal="55305";
             $item->web="http:\/\/www.chipotle.com";
             $item->img=Factory::getRootUrlPlugin().$item->image ;
             $item->hours1="Mon-Sun 11am-10pm";
             $item->hours2="";
             $item->hours3="";
             $item->featured="";
             $item->features="Margaritas";
             $item->date="02/17/18";
             $item->fare=$item->price;
             $item->list_star_sum=HtmlFrontend::get_rating_star($item->rating_avg);
             $item->number_review=count($item->list_review);
             $item->is_user_logged_in = is_user_logged_in();
             $item->user_wishlist = $item->user_wishlist;
             $item->service_id = $item->id;       
             $item->check = in_array($user_id,$item->user_wishlist)?true:false;
        }

        echo json_encode($list);

        die;
    }

    public function get_list_services_by_keyword() {
        $input = Factory::getInput();
        $data = $input->getData();
        $dataForms = json_decode( $data['dataObj'] );
        $dataFormsS = array();
        foreach ($dataForms as $key => $dataForm) {
            if( is_array( $dataForm ) ) {
                if( count($dataForm) == 1 ) {
                    if($key == 'category_id[]') {
                        $dataFormsS["category_id"] = $dataForm;
                    }else if($key == 'total_rating_avg[]') {
                        $dataFormsS["total_rating_avg"] = $dataForm;
                    }else {
                        $dataFormsS[$key] = $dataForm['0'];
                    }
                }else {
                    if($key == 'category_id[]') {
                        $dataFormsS['category_id'] = $dataForm;
                    }else if($key == 'total_rating_avg[]') {
                        $dataFormsS["total_rating_avg"] = $dataForm;
                    }else {
                        $dataFormsS[$key] = $dataForm;
                    }
                }
            }
        }
        foreach( $dataFormsS as $name => $value ) {
            $input->set($name,$value);
        }
        $modelServices = Model::getInstance("services");
        $view_list_services = $modelServices->getListServicesAjax();
        return $view_list_services;
    }

}
