<?php

namespace WpBookingProFrontend\app\controllers;

use Twilio\Rest\Client;
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;
use WpBookingProFrontend\app\helpers\SmsHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class CronjobController extends ControllerFrontend
{
    public static function action_cron_job_send_sms() {
        $modelOrders = Model::getInstance('orders');
        $list_order = $modelOrders->getList();
        $appConfig = Factory::getAppConfig();
        $timezone = $appConfig->get('timezone','');
        date_default_timezone_set("$timezone");
        $now = date("Y-m-d H:i:s");
        foreach ($list_order as $order) {
            $rate = reset($order->list_rate);
            $is_send_sms = $order->is_send_sms;
            if($order->is_recurring == 0) {
                if(strtotime($now) <= strtotime($rate->start_date.' - 12 hours') && strtotime($now) > strtotime($rate->start_date. ' - 1 day') && $is_send_sms == 0) {
                    static::send_sms_schedule($order->id);
                    static::update_sms_status($order->id);
                }
            } else {
                if($order->type_recurring=='daily') {
                    $start_date_daily = strtotime($rate->date_start_recurring.' '.$rate->time_start_recurring.' - 12 hours');
                    $end_date_daily = strtotime($rate->date_end_recurring.' '.$rate->time_start_recurring.' - 12 hours');
                    while($start_date_daily <= $end_date_daily) {
                        $start_date_daily_max = strtotime($rate->date_start_recurring.' '.$rate->time_start_recurring.' - 6 hours');
                        $old_time = isset($order->time_send_sms)?$order->time_send_sms:0;
                        if(strtotime($now) > $start_date_daily && strtotime($now) <= $start_date_daily_max) {
                            if($old_time < $start_date_daily) {
                                static::send_sms_schedule($order->id);
                            }
                            static::update_sms_time_send($order->id,$start_date_daily);
                        }
                        $start_date_daily = strtotime("+1 day", $start_date_daily);
                    }

                } elseif($order->type_recurring == 'weekly' || $order->type_recurring == 'monthly') {
                    $result = call_user_func_array("array_merge", $rate->day_recurring_register);
                    foreach ($result as $day_recurring_register) {
                        $old_time = isset($order->time_send_sms)?$order->time_send_sms:0;
                        if(strtotime($now) > strtotime($day_recurring_register.' - 1 day') && strtotime($now) <= strtotime($day_recurring_register.' - 12 hours')) {
                            if($old_time < strtotime($day_recurring_register)) {
                                static::send_sms_schedule($order->id);
                            }
                            static::update_sms_time_send($order->id,strtotime($day_recurring_register));
                        }
                    }
                }
            }
        }

    }
    public static function send_sms_schedule($order_id) {
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->getItem($order_id);
        $sms = static::get_sms_info_booking();
        $phone_sms = isset($sms->phone_register)?$sms->phone_register:'';
        $phonecode_sms = isset($sms->phonecode)?$sms->phonecode:'';
        if($phone_sms['0'] == '0') {
            $phone_sms = substr($phone_sms,1);
        }
        $suplier_phone = "+$phonecode_sms$phone_sms";
        $content = $sms->content_sms;
        $modelOrderDetail = Model::getInstance('orderdetail');
        $orderDetail = $modelOrderDetail->getItem(reset($order->list_order_detail)->id);

        $modelService = Model::getInstance('service');
        $service = $modelService->getItem($orderDetail->service_id);

        $customer = reset($order->customer);
        $phone_customer = isset($customer->mobile)?$customer->mobile:'';
        $phonecode_customer = isset($customer->phonecode)?$customer->phonecode:'';
        if($phone_customer['0'] == '0') {
            $phone_customer = substr($phone_customer, 1);
        }
        $phone_customer_apply = "+$phonecode_customer$phone_customer";



        foreach ($service as $key => $value) {
            if (is_string($value))
                $content = str_replace("{service_$key}", $value, $content);
        }
        foreach ($order as $key => $value) {
            if (is_string($value))
                $content = str_replace("{order_$key}", $value, $content);
        }
        foreach ($orderDetail as $key => $value) {
            if (is_string($value))
                $content = str_replace("{orderdetail_$key}", $value, $content);
        }
        foreach ($customer as $key => $value) {
            if (is_string($value))
                $content = str_replace("{customer_$key}", $value, $content);
        }
        $content = str_replace('{location_i}', reset($order->list_rate)->location_address, $content);

        $sid = $sms->account_id;
        $token = $sms->auth_token;
        $client = new Client($sid, $token);

        $client->messages->create(
            $phone_customer_apply,
            [
                'from' => $suplier_phone,
                'body' => $content
            ]
        );
    }
    public static function get_sms_info_booking(){
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $send_info_booking=static::get_sms_action_info_booking();
        $query->select('sms.*')
            ->from(Utility::getTableName('sms'). ' AS sms')
            ->where('sms.published=1')
        ;
        $sms = $db->setQuery($query)->loadObject();

        $query->clear()
            ->select("smscontent.*")
            ->from(Utility::getTableName('smscontent'). ' AS smscontent')
            ->where('smscontent.action_sms='.$query->quote($send_info_booking))
        ;
        $sms_content=$db->setQuery($query)->loadObject();
        foreach ($sms_content as $key => $value) {
            if($key != 'id') {
                $sms->{$key} = $value;
            }
        }
        return $sms;

    }
    public static function get_sms_action_info_booking(){
        return "second_send";
    }
    public static function update_sms_status($order_id) {
        $db=Factory::getDBO();
        $query = $db->getQuery(true);
        $query->update(Utility::getTableName('order'))
            ->set('is_send_sms=1')
            ->where('id='.(int)$order_id)
            ;
        $db->setQuery($query)->execute();
    }
    public static function update_sms_time_send($order_id, $time_stamp) {
        $db=Factory::getDBO();
        $query = $db->getQuery(true);
        $query->update(Utility::getTableName('order'))
            ->set('time_send_sms='.(int)$time_stamp)
            ->where('id='.(int)$order_id)
            ;
        $db->setQuery($query)->execute();
    }

}
