"use strict";
(function ($) {
    $.view_service_detail = function (element, options) {
        let defaults = {
            list_event:[],
            person:1,
            service_item:[],
            booking_style:'',
            render_list_review:"",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_event=plugin.settings.list_event;
            let service_item=plugin.settings.service_item;
            let booking_style = plugin.settings.booking_style;
            let $gallery_large = $element.find('.block-gallery-slider-large');
            let $gallery_small = $element.find('.block-gallery-slider-small');
            $gallery_large.slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                prevArrow: ".arrow-prev",
                nextArrow: ".arrow-next",
                fade: true,
                asNavFor: '.block-gallery-slider-small',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]

            });
            setTimeout(function () {
                $(window).trigger('resize');
                $gallery_small.slick({
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    asNavFor: '.block-gallery-slider-large',
                    arrows:false,
                    focusOnSelect: true,
                    responsive: [
                        {
                            breakpoint: 576,
                            settings: {
                                arrows: false,
                                dots:true,
                                slidesToShow: 2,
                                slidesToScroll: 2
                            }
                        }
                    ]
                });

            }, 10);
            let person=plugin.settings.person;
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            let $employee_input = $element.find('input[name=employee_id]');
            $employee_input.on('change', function () {
                let employee_id= $(this).val();
                let list_employee = service_item.list_employee;
                let is_repeat = $element.find('.is-recurring input[type="radio"]:checked').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                let employee_choosen = list_employee.find(function (employee) {
                    if(employee.id == employee_id) {
                        return employee;
                    }
                });
                $element.find('.trainer-info').text(`${employee_choosen.first_name} ${employee_choosen.last_name}`);

                let event_id = $element.find('input[name="event_id"]').val();
                let event_choosen = list_event.find(function (event) {
                    if(event.id == event_id) {
                        return event;
                    }
                });

                if(is_repeat === '0') {
                    let time_start = moment($element.find('input[name="calendar"]').val()).format('HH:mm:ss');
                    if(event_id.trim() !== '' && Object.keys(event_choosen).length !== 0) {
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                    } else {
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    }
                    for(let i=0; i< list_employee.length;i++) {
                        if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                        }

                    }
                } else {
                    let time_start = $element.find('input[name="time_start_recurring"]').val();
                    let date_start = $element.find('input.date-start-recurring').val();
                    let date_end = $element.find('input.date-end-recurring').val();
                    if(type_recurring === 'daily') {
                        let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        if(event_id.trim() !== '' && Object.keys(event_choosen).length !== 0) {
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price * number_day_recurring).toFixed(2)));
                        } else {
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                        }

                    } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                        if(day_of_week.length > 0) {
                            let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            if(event_id.trim() !== '' && Object.keys(event_choosen).length !== 0) {
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                            }

                        } else {
                            $element.find('.sum-day-recurring').text(0);
                            if(event_id.trim() !== '' && Object.keys(event_choosen).length !== 0) {
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price * 0).toFixed(2)));
                            } else {
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }

                    }
                    for(let i=0; i< list_employee.length;i++) {
                        if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                            if(type_recurring === 'daily') {
                                let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                                if(day_of_week.length > 0) {
                                    let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                    $element.find('.sum-day-recurring').text(number_day_recurring);
                                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                                } else {
                                    $element.find('.sum-day-recurring').text(0);

                                    if(event_id.trim() !== '' && Object.keys(event_choosen).length !== 0) {
                                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price * 0).toFixed(2)));
                                    } else {
                                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                                    }
                                }

                            }
                        }

                    }
                }

            });

            let list_working_day= service_item.working_day;
            let array_day_by_number = [];
            if(typeof list_working_day !== 'undefined' && list_working_day !== null && list_working_day.trim() !== '' ) {
                list_working_day = JSON.parse(list_working_day);
                let week = ['Monday','Tuesday' ,'Wednesday' ,'Thursday' ,'Friday','Saturday','Sunday'];
                let array_diff = plugin.arr_diff(list_working_day, week);
                let day_of_week = {
                    'Sunday':0,
                    'Monday':1,
                    'Tuesday':2,
                    'Wednesday':3,
                    'Thursday':4,
                    'Friday':5,
                    'Saturday':6
                };
                for(const prop in day_of_week) {
                    for(let i = 0; i < array_diff.length; i++) {
                        if(prop === array_diff[i]) {
                            array_day_by_number.push(day_of_week[prop]);
                        }
                    }
                }
            }
            let open_time_hour = 0 ;
            let open_time_minute = 0 ;
            if(typeof service_item.open_time !== 'undefined') {
                open_time_hour = parseInt(service_item.open_time.split(':')['0']);
                open_time_minute = parseInt(service_item.open_time.split(':')['1']);
            }
            let close_time_hour = 0;
            let close_time_minute = 0;
            if (typeof service_item.close_time !== 'undefined') {
                close_time_hour = parseInt(service_item.close_time.split(':')['0']);
                close_time_minute = parseInt(service_item.close_time.split(':')['1']);
            }
            let time_disable_array = [];
            for(let i =0; i<=23;i++) {
                if(i < open_time_hour || i > close_time_hour){
                    time_disable_array.push(i);
                }
            }


            $element.find('.form_datetime').data("DateTimePicker").daysOfWeekDisabled ( array_day_by_number);
            $element.find('.form_datetime').data("DateTimePicker").disabledHours ( time_disable_array);
            $element.find('.form_datetime').data("DateTimePicker").disabledTimeIntervals (
                [[moment({h:0}), moment({h:open_time_hour,m:open_time_minute})],
                [moment({h:close_time_hour,m:close_time_minute}), moment({h:24})]]
            );
            $element.find('.time-start-recurring').data("DateTimePicker").disabledTimeIntervals (
                [[moment({h:0}), moment({h:open_time_hour,m:open_time_minute})],
                [moment({h:close_time_hour-(service_item.duration)%10,m:close_time_minute - (service_item.duration - (service_item.duration)%10)*60}), moment({h:24})]]
            );
            $element.find('.time-end-recurring').data("DateTimePicker").disabledTimeIntervals (
                [[moment({h:0}), moment({h:open_time_hour,m:open_time_minute})],
                [moment({h:close_time_hour,m:close_time_minute}), moment({h:24})]]
            );
            $element.find('.form_datetime').on('dp.change', function (e) {
                let value = e.date;
                let time_start = moment(value).format('LT');
                let time_end = moment(value).add(service_item.duration,'hour').format('LT');
                let date_book=moment(value).format('YYYY-MM-DD');
                let list_employee = service_item.list_employee;
                let employee_id = $element.find('input[name="employee_id"]').val();
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);

                if(value !== '') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    for(let i=0; i< list_employee.length;i++) {
                        if(list_employee[i].id === employee_id && moment(time_start,'LT').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'LT').valueOf() <= array_end_time[i].valueOf()) {
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                        }

                    }
                    $element.find('.local-time').text(`${time_start} - ${time_end}`);
                    $element.find('.date-info').text(date_book);
                } else {
                    $element.find('.local-time').text('');
                    $element.find('.date-info').text('');
                }
            });
            $element.find('input.date-start-recurring').on('change',  function () {
                let date_start = $(this).val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(date_start !== '') {
                    $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                }
                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }
                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }

            });
            $element.find('input.date-end-recurring').on('change',  function () {
                let date_end = $(this).val();
                let date_start = $element.find('input.date-start-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(date_end !== '') {
                    $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                }
                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }
                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }

            });
            $element.find('input[name="type_recurring"]').on('change', function () {
                let date_start = $element.find('input.date-start-recurring').val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $(this).val();
                let day_of_week = [];
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(date_end !== '') {
                    $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                }

                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }
                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }


            });

            $element.find('input.time-start-recurring').on('dp.change', function (e) {
                let value = e.date;
                let time_start = moment(value).format('LT');
                let time_end = moment(value).add(service_item.duration,'hour').format('LT');
                let date_start = $element.find('input.date-start-recurring').val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let day_of_week = [];
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(value !== '') {
                    if(type_recurring === 'daily') {
                        let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                        if(day_of_week.length > 0) {
                            let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                        } else {
                            $element.find('.sum-day-recurring').text(0);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                        }

                    }
                    for(let i=0; i< list_employee.length;i++) {
                        if(list_employee[i].id === employee_id && moment(time_start,'LT').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'LT').valueOf() <= array_end_time[i].valueOf()) {
                            if(type_recurring === 'daily') {
                                let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                                if(day_of_week.length > 0) {
                                    let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                    $element.find('.sum-day-recurring').text(number_day_recurring);
                                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                                } else {
                                    $element.find('.sum-day-recurring').text(0);
                                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                                }

                            }                        }

                    }
                    $element.find('.local-time').text(`${time_start} - ${time_end}`);
                } else {
                    $element.find('.local-time').text('');
                }

            });
            $element.find('.is-recurring-item input[type="radio"]').on('change', function () {
                let val = $(this).val();
                if(val === '1') {
                    let date_start = $element.find('input.date-start-recurring').val();
                    let date_end = $element.find('input.date-end-recurring').val();
                    if(date_end !== '') {
                        $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                    }
                    $element.find('.total-day-recurring').show();
                } else {
                    $element.find('.total-day-recurring').hide();
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                }
            });
            $element.find('.block-number-week-recurring input[type="text"]').on('change', function () {
                let date_start = $element.find('input.date-start-recurring').val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(date_end !== '') {
                    $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                }
                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }
                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }
            });
            $element.find('.block-number-month-recurring input[type="text"]').on('change', function () {
                let date_start = $element.find('input.date-start-recurring').val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                if(date_end !== '') {
                    $element.find('.date-info').text('from '+ date_start +' to '+date_end);
                }
                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }

                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }
            });
            let day_of_week_onchange = [];

            $element.find('.day-off-week input[type="checkbox"]').on('change', function () {

                if($(this).is(":checked")) {
                    day_of_week_onchange.push($(this).val())
                } else {
                    let index = day_of_week_onchange.indexOf($(this).val());
                    if(index > -1) {
                        day_of_week_onchange.splice(index,1);
                    }
                }
                let date_start = $element.find('input.date-start-recurring').val();
                let date_end = $element.find('input.date-end-recurring').val();
                let type_recurring = $element.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let time_start = $element.find('input[name="time_start_recurring"]').val();
                let list_employee = service_item.list_employee;
                let array_start_time = list_employee.map(v=>moment(v.start_time,'HH:mm:ss'));
                let array_end_time = list_employee.map(v=>moment(v.end_time,'HH:mm:ss'));
                let array_price = list_employee.map(v=>v.price);
                let employee_id = $element.find('input[name="employee_id"]').val();
                if(type_recurring === 'daily') {
                    let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                    $element.find('.sum-day-recurring').text(number_day_recurring);
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                    if(day_of_week_onchange.length > 0) {
                        let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week_onchange);
                        $element.find('.sum-day-recurring').text(number_day_recurring);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * number_day_recurring).toFixed(2)));
                    } else {
                        $element.find('.sum-day-recurring').text(0);
                        $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                        $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                    }

                }

                for(let i=0; i< list_employee.length;i++) {
                    if(list_employee[i].id === employee_id && moment(time_start,'HH:mm:ss').valueOf() >= array_start_time[i].valueOf() && moment(time_start,'HH:mm:ss').valueOf() <= array_end_time[i].valueOf()) {
                        if(type_recurring === 'daily') {
                            let number_day_recurring = plugin.countDayRecurringDaily(date_start, date_end);
                            $element.find('.sum-day-recurring').text(number_day_recurring);
                            $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                            $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                        } else if( type_recurring === 'weekly' || type_recurring === 'monthly') {
                            if(day_of_week_onchange.length > 0) {
                                let number_day_recurring = plugin.countDayRecurringWeeklyAndMonthly(date_start,date_end,day_of_week_onchange);
                                $element.find('.sum-day-recurring').text(number_day_recurring);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i]).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(array_price[i] * number_day_recurring).toFixed(2)));
                            } else {
                                $element.find('.sum-day-recurring').text(0);
                                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price).toFixed(2)));
                                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(service_item.price * 0).toFixed(2)));
                            }

                        }                        }

                }


            });
            $element.find('.btn-book-now').on('click',function (e) {
                let $form = $(this).closest('form[name="client-form"]');
                let is_repeat = $form.find('.is-recurring input[type="radio"]:checked').val();
                let type_repeat = $form.find('.block-type-of-recurring input[type="radio"]:checked').val();
                let employee_id = $form.find('input[name="employee_id"]').val();
                let time_value = $form.find('.mirror_field').val();
                let day_of_week = [];
                $element.find('input[name="day_of_week[]"]:checked').each(function () {
                    day_of_week.push($(this).val())
                });
                let number_week_recurring = $form.find('input[name="number_week_recurring"]').val();
                let number_month_recurring = $form.find('input[name="number_month_recurring"]').val();
                let date_start_recurring = $form.find('input[name="date_start_recurring"]').val();
                let time_start_recurring = $form.find('input[name="time_start_recurring"]').val();
                let date_end_recurring = $form.find('input[name="date_end_recurring"]').val();
                let time_end_recurring = $form.find('input[name="time_end_recurring"]').val();
                if (employee_id === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    },500,"linear");
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Expert</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if(is_repeat === '0') {
                    if (time_value === "") {
                        $('body,html').animate({
                            scrollTop: $element.find('.block-booking-information').offset().top
                        },500,"linear");
                        $.alert({
                            title:'',
                            content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                            container:'.block-alert',
                            buttons: {
                                formSubmit: {
                                    text: '<i class="icon-nb-close"></i>',
                                    btnClass: 'btn-red',
                                }
                            }
                        });
                        return false;
                    }
                } else {
                    if(date_start_recurring === '' || time_start_recurring === '' || date_end_recurring === '' || time_end_recurring === '') {
                        $('body,html').animate({
                            scrollTop: $element.find('.block-set-recurring-time').offset().top
                        },500,"linear");
                        $.alert({
                            title:'',
                            content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                            container:'.block-alert',
                            buttons: {
                                formSubmit: {
                                    text: '<i class="icon-nb-close"></i>',
                                    btnClass: 'btn-red',
                                }
                            }
                        });
                        return false;
                    }
                    if(type_repeat === 'weekly') {
                        if(day_of_week.length === 0) {
                            $('body,html').animate({
                                scrollTop: $element.find('.day-off-week').offset().top
                            },500,"linear");
                            $.alert({
                                title:'',
                                content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your day of week</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                                container:'.block-alert',
                                buttons: {
                                    formSubmit: {
                                        text: '<i class="icon-nb-close"></i>',
                                        btnClass: 'btn-red',
                                    }
                                }
                            });
                            return false;
                        }
                        if(number_week_recurring==='' || number_week_recurring===0) {
                            $('body,html').animate({
                                scrollTop: $element.find('.block-number-week-recurring').offset().top
                            },500,"linear");
                            $.alert({
                                title:'',
                                content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your number of week</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                                container:'.block-alert',
                                buttons: {
                                    formSubmit: {
                                        text: '<i class="icon-nb-close"></i>',
                                        btnClass: 'btn-red',
                                    }
                                }
                            });
                            return false;
                        }

                    } else if (type_repeat === 'monthly') {
                        if(day_of_week.length === 0) {
                            $('body,html').animate({
                                scrollTop: $element.find('.day-off-week').offset().top
                            },500,"linear");
                            $.alert({
                                title:'',
                                content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your day of week</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                                container:'.block-alert',
                                buttons: {
                                    formSubmit: {
                                        text: '<i class="icon-nb-close"></i>',
                                        btnClass: 'btn-red',
                                    }
                                }
                            });
                            return false;
                        }
                        if(number_month_recurring==='' || number_month_recurring===0) {
                            $('body,html').animate({
                                scrollTop: $element.find('.block-number-month-recurring').offset().top
                            },500,"linear");
                            $.alert({
                                title:'',
                                content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your number of week</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                                container:'.block-alert',
                                buttons: {
                                    formSubmit: {
                                        text: '<i class="icon-nb-close"></i>',
                                        btnClass: 'btn-red',
                                    }
                                }
                            });
                            return false;
                        }
                    }
                }
                if (!$form.valid()) {
                    $('body,html').animate({
                        scrollTop: $element.find('.wrapper-block-check-out').offset().top
                    },500,"linear");
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-booknow').on('click',function () {
                let $block_event= $(this).closest('.block-event-item');
                $('body,html').animate({
                    scrollTop: $element.find('form.booking-form').offset().top
                },500,"linear");
                let event_id=$block_event.data('event_id');
                let event_choosen = list_event.find(function (event) {
                    if(event.id == event_id) {
                        return event;
                    }
                });
                $element.find('input[name="event_id"]').val(event_id);
                $element.find('.location-info').text(event_choosen.list_location[0].address)
                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(parseFloat(event_choosen.price).toFixed(2)));
            });

            $element.find('form[name="form-review"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-save-review').on('click', function () {
                let $form = $(this).closest('form[name="form-review"]');
                let rating_ambience = $form.find('input[name="rating_ambience"]').val();
                let rating_cleanliness = $form.find('input[name="rating_cleanliness"]').val();
                let rating_staff = $form.find('input[name="rating_staff"]').val();
                let rating_value = $form.find('input[name="rating_value"]').val();
                if(rating_ambience === '' || rating_cleanliness === '' || rating_staff === '' || rating_value === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            let $render_item_review = $render_list_review.filter('.block-review-item');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function (event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function (index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });

        };
        plugin.countDayRecurringDaily = function (startDate, endDate) {
            return moment(endDate).diff(moment(startDate), "days") + 1;
        };
        plugin.countDayRecurringWeeklyAndMonthly = function (startDate, endDate, arrDayOfWeeek) {
            var number_day_recurring = 0;
            var arrStartDate = startDate.split('-');
            var arrEndDate = endDate.split('-');
            var days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
            for (var d = new Date(arrStartDate[0], arrStartDate[1] - 1, arrStartDate[2]); d <= new Date(arrEndDate[0], arrEndDate[1] - 1, arrEndDate[2]); d.setDate(d.getDate() + 1)) {
                var day = days[ d.getDay() ];
                for(let i = 0; i < arrDayOfWeeek.length; i++) {
                    if(day.toLocaleLowerCase() === arrDayOfWeeek[i]) {
                        number_day_recurring++;
                    }
                }
            }
            return number_day_recurring;
        }
        plugin.formatNumber = function (num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
        };
        plugin.arr_diff = function (a1, a2) {
            let a = [], diff = [];
            if(a1.length > 0 && a2.length > 0) {
                for (let i = 0; i < a1.length; i++) {
                    a[a1[i]] = true;
                }
                for (let i = 0; i < a2.length; i++) {
                    if (a[a2[i]]) {
                        delete a[a2[i]];
                    } else {
                        a[a2[i]] = true;
                    }
                }
                for (let k in a) {
                    diff.push(k);
                }
            }
            return diff;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_service_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_service_detail')) {
                let plugin = new $.view_service_detail(this, options);
                $(this).data('view_service_detail', plugin);
            }
        });
    }
})(jQuery);
