"use strict";
(function ($) {
    $.view_list_services = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[]
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $checkbox_category = $element.find('.check-box-category');
            let $checkbox_service = $element.find('.check-box-service');
            let dropdown_toggle = $element.find('.dropdown-toggle');
            let $direction = $element.find('input[name="direction"]').val();
            $element.find('.heart').on('click', function () {
                $(this).toggleClass('active');
            });

            $checkbox_category.on('ifChecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                $ul_list_service.find('.check-box-service').iCheck('check');

            });

            if($direction ==="ASC"){
                dropdown_toggle.find('.sort-by').text('Lowest Price');
            }else if($direction === "DESC"){
                dropdown_toggle.find('.sort-by').text('Highest Price');
            } else {
                dropdown_toggle.find('.sort-by').text('Sort By');
            }
            $checkbox_category.on('ifUnchecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                if (!triggeredByChild) {
                    $ul_list_service.find('.check-box-service').iCheck('uncheck');
                }
            });
            $checkbox_service.on('ifUnchecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                $block_label.find('.check-box-category').iCheck('uncheck');
            });
            $checkbox_service.on('ifChecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                let $current_service=$ul_list_service.find('.check-box-service');
                if ($current_service.filter(':checked').length === $current_service.length) {
                    $block_label.find('.check-box-category').iCheck('check');
                }
            });

            $element.find('.ul-list-service').slideUp();
            $element.find('.icon-nb-down-arrow').click(function (e) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service =$block_label.next();
                $ul_list_service.slideToggle();
                $(this).toggleClass('active')
            });

            $element.find('.sort-display a').on('click',function (e) {
                let $form=$element.find('form.form-search-service');
                let sort=$(this).data('sort');
                let direction=$(this).data('direction');
                let text =$(this).text();
                dropdown_toggle.find('.sort-by').text(text);
                $element.find('input[name="sort"]').val(sort);
                $element.find('input[name="direction"]').val(direction);
                $form.submit();
            });

            $element.find('select.list-location').select2();
            $element.find('select.list-employee').select2();
            $element.find('input.input-near-me').on('change', function () {
                if($(this).is(":checked")) {
                    if(navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(function(position) {
                            var latitude = position.coords.latitude;
                            var longitude = position.coords.longitude;
                            $element.find('input[name="latitude"]').val(latitude);
                            $element.find('input[name="longitude"]').val(longitude);
                        }, function () {
                            $element.find('input[name="latitude"]').val('');
                            $element.find('input[name="longitude"]').val('');
                        })
                    } else {
                        alert("Sorry, your browser does not support HTML5 geolocation.");
                    }
                } else {
                    $element.find('input[name="latitude"]').val('');
                    $element.find('input[name="longitude"]').val('');
                }
            })

            let total_record=plugin.settings.total_record;
            let limit=plugin.settings.limit;
            let start=plugin.settings.start;
            let $fist_show=true;
            if (total_record>limit && total_record % limit >0 ){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt((total_record/limit) + 1),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else if(total_record>limit && total_record % limit ==0){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt(total_record/limit),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            }
            else if(total_record<=limit && total_record>0) {
                $element.find('#pagination-services').twbsPagination({
                    totalPages: 1,
                    visiblePages: 1,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else {
                $element.find('#pagination-services').hide();
            }
            $element.find('.heart').on('click',function(e){
                let $service_item = $(this).closest('.wishlist-item');

                let service_id = $service_item.data('service_id');
                let user_id = $service_item.data('user_id');
                if(user_id==""){
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {

                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        console.log("response",response);
                    }
                });
            })
        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_services = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_services')) {
                let plugin = new $.view_list_services(this, options);
                $(this).data('view_list_services', plugin);
            }
        });
    }
})(jQuery);
