"use strict";
(function ($) {
    $.view_list_services = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            page_detail_service:'',
        };

        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $checkbox_category = $element.find('.check-box-category');
            let $checkbox_service = $element.find('.check-box-service');
            let dropdown_toggle = $element.find('.dropdown-toggle');
            let $direction = $element.find('input[name="direction"]').val();            
            $checkbox_category.on('ifChecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                $ul_list_service.find('.check-box-service').iCheck('check');

            });

            if($direction ==="ASC"){
                dropdown_toggle.find('.sort-by').text('Lowest Price');
            }else if($direction === "DESC"){
                dropdown_toggle.find('.sort-by').text('Highest Price');
            } else {
                dropdown_toggle.find('.sort-by').text('Sort By');
            }
            $checkbox_category.on('ifUnchecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                if (!triggeredByChild) {
                    $ul_list_service.find('.check-box-service').iCheck('uncheck');
                }
            });
            $checkbox_service.on('ifUnchecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                $block_label.find('.check-box-category').iCheck('uncheck');
            });
            $checkbox_service.on('ifChecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                let $current_service=$ul_list_service.find('.check-box-service');
                if ($current_service.filter(':checked').length === $current_service.length) {
                    $block_label.find('.check-box-category').iCheck('check');
                }
            });

            $element.find('.ul-list-service').slideUp();
            $element.find('.icon-nb-down-arrow').click(function (e) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service =$block_label.next();
                $ul_list_service.slideToggle();
                $(this).toggleClass('active')
            });

            // $element.find('.sort-display a').on('click',function (e) {
                // let $form=$element.find('form.form-search-service');
                // let sort=$(this).data('sort');
                // let direction=$(this).data('direction');
                // let text =$(this).text();
                // dropdown_toggle.find('.sort-by').text(text);
                // $element.find('input[name="sort"]').val(sort);
                // $element.find('input[name="direction"]').val(direction);
            //     $form.submit();
            // });

            $element.find('select.list-location').select2();
            $element.find('select.list-employee').select2();
            $element.find('input.input-near-me').on('change', function () {
                if($(this).is(":checked")) {
                    if(navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(function(position) {
                            var latitude = position.coords.latitude;
                            var longitude = position.coords.longitude;
                            $element.find('input[name="latitude"]').val(latitude);
                            $element.find('input[name="longitude"]').val(longitude);
                        }, function () {
                            $element.find('input[name="latitude"]').val('');
                            $element.find('input[name="longitude"]').val('');
                        })
                    } else {
                        alert("Sorry, your browser does not support HTML5 geolocation.");
                    }
                } else {
                    $element.find('input[name="latitude"]').val('');
                    $element.find('input[name="longitude"]').val('');
                }
            });
            /*
             * Start: Viet Dev
             */
            let limit=parseInt(plugin.settings.limit);
            $element.find('input[name="limit1"]').val(limit);
            let page = parseInt(plugin.settings.page);
            let start = parseInt(plugin.settings.start); 
            $(window).load(function() {
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="limit1"]').val(limit);                
            });  
            var filterAjaxEvent = plugin.debounce(function () {  
                $element.find('input[name="limit1"]').val(limit);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            $element.find('input[name="limit"]').val(limit);
            $element.find('input[name="keyword"]').on('keyup', filterAjaxEvent);
            $element.find('select[name="employee_id"]').on('change', filterAjaxEvent);
            $element.find('select[name="location_id"]').on('change', filterAjaxEvent);
            $element.find('.ul-list-category input[name="category_id[]"]').on('change', filterAjaxEvent);
            $element.find('.ul-list-rating input[name="total_rating_avg"]').on('change', filterAjaxEvent);            
            $('body').on('click','.nav-tabs li', function() {
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
            })     
            let input_page = page;            
            var filterAjaxEventLoadMore = plugin.debounce(function () { 
                $element.find('input[name="limit1"]').val(limit);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            var filterAjaxLoadMore = plugin.debounce(function () {  
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_loadmore_ajax(dataObj);
            }, 300);
            var tabAjaxEvent = plugin.debounce(function () {  
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.tab_ajax(dataObj);
            }, 300);
            $element.find('#pagination-services-ajax').on('click', function() {
                let input_limit = parseInt($element.find('input[name="limit1"]').val());
                let input_page = page;
                let input_start = parseInt($element.find('input[name="start"]').val());
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                input_start = parseInt(input_start)+limit;
                $element.find('input[name="start"]').val(input_start);
                input_limit = parseInt(input_limit)+limit;
                $element.find('input[name="limit1"]').val(input_limit);
                input_page = parseInt(input_page)+page;
                $element.find('input[name="page"]').val(input_page);
                $element.find('input[name="link_load"]').val('1');
            });
            $element.find('#pagination-services-ajax').on('click', filterAjaxLoadMore);
            $('body').on('click', '.nav-tabs li', tabAjaxEvent);     
            $element.find('.sort-display a').click(filterAjaxEventLoadMore);    
            $element.find('.sort-display a').click(function(){
                let dropdown_toggle = $element.find('.dropdown-toggle');
                let $direction = $element.find('input[name="direction"]').val();
                let $form=$element.find('form.form-search-service');
                let sort=$(this).data('sort');
                let direction=$(this).data('direction');
                $element.find('input[name="sort"]').val(sort);
                $element.find('input[name="direction"]').val(direction);
            });    
            $('body').on('click', '.sort-display a', function(){
                let dropdown_toggle = $element.find('.dropdown-toggle');
                let $direction = $element.find('input[name="direction"]').val();
                let $form=$element.find('form.form-search-service');
                let sort=$(this).data('sort');
                let direction=$(this).data('direction');
                $element.find('input[name="sort"]').val(sort);
                $element.find('input[name="direction"]').val(direction);
            });      
            $('body').on('click', '.sort-display a', filterAjaxEventLoadMore);   
            // $(window).load(function() {
            //     var sPageURL = window.location.search.substring(1),
            //     sURLVariables = sPageURL.split('&'),
            //     sParameterName,
            //     i;
            //     for (i = 0; i < sURLVariables.length; i++) {
            //         sParameterName = sURLVariables[i].split('=');

            //         if (sParameterName[0] === sParam) {
            //             return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            //         }
            //     }
            // });

            /*
             * End: Viet Dev
             */
            $('body').on('click','.category-name-heart .heart',function(e){
                let $service_item = $(this).closest('.wishlist-item');
                let service_id = $service_item.data('service_id');
                let user_id = $element.find('.data-listservice-ajax').data('user-id');
                let $wishlist_icon = $(this);

                if(user_id=="" && user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
            let total_record=plugin.settings.total_record;
            let $fist_show=true;
            if (total_record>limit && total_record % limit >0 ){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt((total_record/limit) + 1),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else if(total_record>limit && total_record % limit ==0){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt(total_record/limit),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            }
            else if(total_record<=limit && total_record>0) {
                $element.find('#pagination-services').twbsPagination({
                    totalPages: 1,
                    visiblePages: 1,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else {
                $element.find('#pagination-services').hide();
            }

        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-service').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.filter_ajax = function(dataObj) {
            console.log(dataObj);
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_detail_service: plugin.settings.page_detail_service
                },
                beforeSend: function() {
                    $('body').loadingModal(); 
                    $(window).load(function() {
                        $element.find('#pagination-services-ajax').hide();
                    });
                },
                success: function(res) {

                    let data= JSON.parse(res);
                    $element.find('.wrapper-service-list').empty();
                    $element.find('.wrapper-service-grid').empty();
                    if( data.data.template1 || data.data.template2 ) {
                        $element.find('.wrapper-service-list').append(data.data.template2); 
                        $element.find('.wrapper-service-grid').append(data.data.template1);
                    }else {
                        $element.find('.wrapper-service-list').append('<div class="alert-block"><span>Could not found any hotels</span></div>'); 
                        $element.find('.wrapper-service-grid').append('<div class="alert-block"><span>Could not found any hotels</span></div>');
                    }
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                         $element.find('.data-listservice-ajax .block-top-result .number').text(data.data.total +" services found");
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }
                        });
                        $element.find('.block-display-button .tab-pane').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).data('layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }
                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                        $(window).load(function() {
                        $element.find('#pagination-services-ajax').show();
                        });
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if( index == "user_id" ) {
                                $params += index+"="+val;
                            }else {
                                $params += "&"+index+"="+val;
                            }
                            
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }                     
                },
            })
        };
        plugin.tab_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_detail_service: plugin.settings.page_detail_service
                },
                beforeSend: function() {
                    $('body').loadingModal();                
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if( index == "user_id" ) {
                                $params += index+"="+val;
                            }else {
                                $params += "&"+index+"="+val;
                            }
                            
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }                     
                },
            })
        };
        plugin.filter_loadmore_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_detail_service: plugin.settings.page_detail_service
                },
                beforeSend: function() {
                    $('body').loadingModal();  
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    
                    if( data.data.template1 || data.data.template2 ) {
                        $element.find('.wrapper-service-list').append(data.data.template2); 
                        $element.find('.wrapper-service-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                    }
                    if(data.data.layout) {

                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        console.log(history.pushState);

                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if( index == "user_id" ) {
                                $params += index+"="+val;
                            }else {
                                $params += "&"+index+"="+val;
                            }
                            
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }                     
                },
            })
        };
        plugin.example_function = function () {
        }
        plugin.window_after_load = function() {
            var output = plugin.convert_data_form();
            let dataObj = {};
            $(output).each(function(i, field){
                dataObj[field.name] = field.value;
            });
            plugin.filter_ajax(dataObj);
        }
        plugin.init();
        plugin.window_after_load();
    }
    $.fn.view_list_services = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_services')) {
                let plugin = new $.view_list_services(this, options);
                $(this).data('view_list_services', plugin);
            }
        });
    }
})(jQuery);