<?php
namespace WpBookingProFrontend\app\Html;

use WpBookingPro\Factory;

class HtmlFrontend
{
    public static function render_checkbox($value="",$key="item"){
        ob_start();
        include __DIR__.DS."/hmtl/checkbox.php";
        $content=ob_get_clean();
        return $content;
    }
    public static function render_check_all($key="item"){
        ob_start();
        $content=ob_get_clean();
        return $content;
    }
    public static function render_date($date,$format="m/d/Y"){
        $date=Factory::getDate($date);
        ob_start();
        include __DIR__.DS."/hmtl/date.php";
        $content=ob_get_clean();
        return $content;
    }
    public static function get_rating_star($rating = 0,$max_star=5){
        $list_star =[];
        while ($rating > $max_star) {
            $rating = $rating - $max_star;
        }
        if($rating > 0) {
            $star = $rating % 10;
            $non_star = ($max_star - $rating) % 10;
            $half_star = ceil($max_star-$star-$non_star);
        } else {
            $star = 0;
            $half_star = 0;
            $non_star = 0;
        }

        $list_star=array($star, $half_star, $non_star);
        return $list_star;
    }

    public static function render_price($price,$format="$")
    {
        ob_start();
        include __DIR__.DS."/hmtl/price.php";
        $content=ob_get_clean();
        return $content;
    }
    public static function is_multi_product_in_cart()
    {
        $appConfig = Factory::getAppConfig();
        return (boolean)$appConfig->get('multi_product_in_cart', 0);
    }
}