<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
$this->user=FactoryAlias::getUser(); 
$curent_user_id = $this->user->id;


$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List wishlist");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("category.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-category">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"><?php echo (HtmlBackend::render_checkbox('All')) ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Service Name','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                        <?php
                            if ($item->user_id == $curent_user_id):
                        ?>
                        <tr>
                            <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                            <td class="service-id nowrap"><?php esc_html_e($item->id); ?></td>
                            <td class="service-name nowrap"><?php esc_html_e($item->service_name); ?></td>
                            <td class="service-action">
                                <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("wishlist","wishlist.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="icon-nb-delete"></i></a>
                            </td>
                        </tr>
                        <?php  endif; ?>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_category.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-category', 'view_list_category', array(

), "admin_woopanel/app/assets/js/view_list_category.js");
?>