<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List states");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-states">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('State name','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Country name','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Publish','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="state-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="country-name"><?php echo ($item->country_name); ?> </td>
                        <td class="state-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <div class="button-action">
                                <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("states","states.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_states.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-states', 'view_list_states', array(

), "admin_woopanel/app/assets/js/view_list_states.js");
?>