<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List sms content");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("smscontent.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-smscontent">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Action','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Title','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('SMS Content','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="sms-content-id nowrap"><?php esc_html_e($item->id); ?></td>
                        <td class="action-sms nowrap"><?php esc_html_e($item->action_sms); ?></td>
                        <td class="title-sms nowrap"><?php esc_html_e($item->title_sms); ?></td>
                        <td class="content-sms nowrap"><?php esc_html_e($item->content_sms); ?></td>
                        <td class="sms-content-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("smscontent.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("smscontent","smscontent.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_smscontent.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-smscontent', 'view_list_smscontent', array(

), "admin_woopanel/app/assets/js/view_list_smscontent.js");
?>