<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
WpBookingProHtmlWooPanelAlias::load_jquery_library('loading_js');
WpBookingProHtmlWooPanelAlias::load_jquery_library('ui');
WpBookingProHtmlWooPanelAlias::load_jquery_library('content_edit_table');
ToolBar::setTitle("List service");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
ob_start();
$this->loadTemplate('list_service_item');
$html_service_item = ob_get_clean();
ob_start();
$this->loadTemplate('list_category_item');
$html_category_item = ob_get_clean();
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("service.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-service">
            <div class="list-service-service main-table">
                <div class="row">
                    <div class="col-md-6">
                        <h4><?php esc_attr_e('All categories','wpbookingpro') ?></h4>
                        <div class="list-category">
                            <div class="row wrapper-category">
                                <?php foreach ($this->list_service_by_category as $index_category=>  $category) { ?>
                                    <?php $this->item=$category ?>
                                    <?php $this->index_category=$index_category ?>
                                    <?php  $this->loadTemplate('list_category_item') ?>
                                <?php } ?>
                                <div class="col-md-6">
                                    <a class="btn-block btn-add-category" href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("category","category.add")) ?>"><i class="icon-nb-plus"></i> <span><?php esc_attr_e('Add category','wpbookingpro') ?></span></a>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="col-md-6">
                        <h4><?php esc_attr_e('All services','wpbookingpro') ?></h4>
                        <div class="wrapper-list-service-by-category">
                            <?php foreach ($this->list_service_by_category as $index_category => $category) { ?>
                                <div class="list-service-by-category <?php echo($index_category == 0 ? ' active ' : null) ?>"
                                     data-id="tab-category-<?php esc_html_e($category->id); ?>"
                                     data-category_id="<?php esc_html_e($category->id); ?>">
                                    <?php foreach ($category->list_service as $service) { ?>
                                        <?php $this->item=$service ?>
                                        <?php  $this->loadTemplate('list_service_item') ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_service.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-service', 'view_list_service', array(
    "list_service_by_category"=>  $this->list_service_by_category,
    "html_service_item"=>  $html_service_item,
    "html_category_item"=>  $html_category_item,
), "admin_woopanel/app/assets/js/view_list_service.js");
?>