<?php

namespace WpBookingProAdminWooPanel\app\views\payment;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class PaymentView extends View
{
    public function display($tpl)
    {
        $modelPayment = Model::getInstance("payment");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add_payment('payment.add_payment');
                ToolBar::delete("payment.delete_list");
                ToolBar::_clone("payment.clone_list");
                $model = Model::getInstance("payment");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit payment');
                ToolBar::apply("payment.apply");
                ToolBar::save("payment.save");
                ToolBar::cancel("payment.cancel");
                ToolBar::back_to_list("payment.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelPayment->getItem($id);
                $this->form = $modelPayment->getForm();
                break;
        }
        return parent::display($tpl);
    }
}