<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List order status");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("orderstatus.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-orderstatus">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th class="name-order-status nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        <th class="id-order-status nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="ordering-order-status nowrap"><?php esc_attr_e('Ordering','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php esc_html_e($item->name); ?></td>
                        <td class="id nowrap"><?php esc_html_e($item->id); ?></td>
                        <td class="ordering nowrap"><?php esc_html_e($item->ordering); ?></td>
                        <td class="orderstatus-action">
                            <div class="button-action">
                                <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("orderstatus.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("orderstatus","orderstatus.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_orderstatus.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-orderstatus', 'view_list_orderstatus', array(

), "admin_woopanel/app/assets/js/view_list_orderstatus.js");
?>