<?php
use WpBookingPro\Language\Text;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
$item = $this->item;
?>
<div class="view-orderpackage-form">
    <form action="" name="admin_woopanel-form" method="post" enctype="multipart/form-data">
        <table id="example" class="display table"">
            <?php if(count($item->list_order_package))  { ?>
                <thead>
                <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
                    <th class="nowrap"><?php esc_attr_e('Start time','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('End time','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Assigned to','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Service','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Duration','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Location','wpbookingpro') ?></th>
                </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_order_package as $order_package) { ?>
                        <tr class="list-rate-info">
                            <td class="nowrap">
                                <?php echo(HtmlBackend::render_date($order_package->rate->start_date,"H:i")); ?>
                            </td>
                            <td class="nowrap">
                                <?php echo(HtmlBackend::render_date($order_package->rate->end_date,"H:i")); ?>
                            </td>
                            <td class="nowrap employee">
                                <div class="img-box">
                                    <img class="employee-item-image pull-left" src="<?php echo(FactoryAlias::getRootUrlPlugin() . $order_detail->employee_image)  ?>" alt="employee-item-image" />
                                </div>
                                <h4 class="pull-right employee-item-name"><?php esc_html_e($order_package->employee_full_name); ?></h4>
                            </td>
                            <td class="nowrap service-name"><?php esc_html_e($order_package->service_name); ?></td>
                            <td class="nowrap"><?php esc_html_e($order_package->rate->duration) ?></td>
                            <td class="nowrap"><?php esc_html_e($order_package->location_address); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            <?php }?>
        </table>
    </form>
</div>
<?php
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/list_form_orderpackage.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-orderpackage-form', 'list_view_order_package', array(

), "admin_woopanel/app/assets/js/list_view_order_package.js");
?>
