<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_location.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List locations");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("location.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-location">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Name','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Address','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Phone number','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('State country','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="location-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="location-address">
                            <p><?php echo ($item->address); ?> </p>
                        </td>
                        <td class="location-phone">
                            <?php
                                $mobile = isset($item->mobile)?$item->mobile:'';
                                if($mobile['0'] == 0) {
                                    $mobile = substr($mobile,1);
                                }
                                $phonecode = isset($item->phonecode)?$item->phonecode:'';
                                echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                        <td class="location-country-name"><?php echo ($item->state_name.' - '.$item->country_name); ?> </td>
                        <td class="location-action">
                            <div class="button-action">
                                <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("location.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("location",'location.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-location', 'view_list_location', array(

), "admin_woopanel/app/assets/js/view_list_location.js");
?>