<?php

use WpBookingPro\Factory;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
$doc = Factory::getDocument();
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="wrapper-employee-item" data-employee_id="<?php esc_html_e($item->id); ?>">
    <?php echo (HtmlBackend::render_checkbox($item->id)) ?>
    <div class="wrapper-employee-content">
        <div class="employee-item-image pull-left">
            <div>
                <img class="image-cover" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?><?php echo ($item->cover == null) ? 'admin/app/assets/images/no-image.jpg' : $item->cover ?>" alt="employee-item-image" />
            </div>
        </div>
        <div class="employee-item-content pull-left">
            <p><label class="name"><?php esc_html_e(ucwords($item->full_name)) ?></label></p>
            <p><label class="email"><?php esc_html_e($item->email); ?></label></p>
            <p>
                <label class="mobile">
                    <?php
                    $mobile = isset($item->mobile)?$item->mobile:'';
                    if(trim($mobile)!= '' && $mobile['0'] == 0) {
                        $mobile = substr($mobile,1);
                    }
                    $phonecode = isset($item->phonecode)?$item->phonecode:'';
                    echo (esc_html('+'.$phonecode . $mobile));
                    ?>
                </label>
            </p>
        </div>
    </div>
    <div class="employee-action">
        <?php if ($item->published == 1) { ?>
            <div class="away">
                <p><?php esc_attr_e('Away','wpbookingpro') ?></p>
            </div>
        <?php } else { ?>
            <div class="away">
                <p><?php esc_attr_e('Offline','wpbookingpro') ?></p>
            </div>
        <?php } ?>
        <a class="btn btn-primary btn-edit" href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("employee.form",array("id"=>$item->id))) ?>" >
            <i class="icon-nb-edit"></i>
            <?php esc_attr_e('Edit','wpbookingpro')?>
        </a>
    </div>
</div>
