<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('chart_js');
WpBookingProHtmlWooPanel::load_jquery_library('bootstrap_tabs');
WpBookingProHtmlWooPanel::load_jquery_library('datatables');
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_db_appointments_dashboard.less');
$number_user= count((array)$this->list_customer);
$number_month=count((array)$this->list_order_by_month);
$number_month_order=count((array)$this->list_order_by_month,1);
$number_oder= $number_month_order - $number_month;
$number_categories= count((array)$this->list_categories);
$total=0;

?>
    <div class="view-db-appointments-dashboard">
        <div class="logo-appointment">
            <img src="<?php echo(Factory::getRootUrlPlugin())?>admin_woopanel/app/assets/images/Logo WPAppointment.svg" alt="">
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="block-item-widget user">
                    <div class="icon-block">
                        <i class="fas fa-user-friends"></i>
                    </div>
                    <div class="content-block">
                        <h4> <?php esc_attr_e('New users','wpbookingpro') ?></h4>
                        <p class="text-left"><?php esc_attr_e('Joined New User','wpbookingpro') ?> <p class="number-right"><?php echo ($number_user?$number_user:0); ?> </p></p>
                    </div>
                </div>
                <div class="block-item-widget order">
                    <div class="icon-block">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('New orders','wpbookingpro') ?></h4>
                        <p class="text-left"><?php esc_attr_e('All Orders','wpbookingpro') ?> <p class="number-right"> <?php esc_html_e($number_oder);  ?></p> </p>
                    </div>
                </div>

                <div class="block-item-widget delivery">
                    <div class="icon-block">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('Categories','wpbookingpro') ?></h4>
                        <p class="text-left"><?php esc_attr_e('All Categories Publish','wpbookingpro') ?> <p class="number-right"><?php esc_html_e($number_categories);  ?></p> </p>
                    </div>
                </div>
                <div class="block-item-widget monthly">
                    <div class="icon-block">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="content-block">
                        <?php foreach ($this->list_order_in_year as $item) { ?>
                        <?php $total += $item->total ?>
                        <?php } ?>
                        <h4><?php esc_attr_e('Total Revenue','wpbookingpro') ?></h4>
                        <p class="text-left"> <?php esc_attr_e('Net sales in this period','wpbookingpro') ?> <p class="number-right"><?php echo (HtmlBackend::render_price($total)); ?></p></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
        <div class="total-order">
            <h3><?php esc_attr_e('Total order','wpbookingpro') ?></h3>
            <canvas class="order-this-week"></canvas>
        </div>
            </div>
            <div class="col-md-4">
                <div class="new-customer">
                    <h3><?php esc_attr_e('New customer','wpbookingpro') ?></h3>
                    <table class="table table-responsive table-customer">
                        <thead>
                        <tr>
                            <th class="nowrap"><?php esc_html_e('Id','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Phone','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Order time','wpbookingpro') ?> </th>
                        </tr>
                        </thead>
                        <tbody class="list-wbcustomer main-table">
                        <?php foreach ($this->list_customer as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_customer') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
        <div class="row">
            <div class="col-md-8">

        <div class="monthly-profits">
            <h3><?php esc_attr_e('Month profits','wpbookingpro') ?></h3>
            <canvas class="employee-chart"></canvas>
        </div>
            </div>
            <div class="col-md-4">
                <div class="list-category">
                    <h3><?php esc_attr_e('List Categories','wpbookingpro') ?></h3>
                    <table class="table table-responsive table-category">
                        <thead>
                        <tr>
                            <th class="view-list-category-th nowrap"><?php esc_attr_e('Id','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"> <?php esc_attr_e('Image','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        </tr>
                        </thead>
                        <tbody class="list-category main-table">
                        <?php foreach ($this->list_categories as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_category') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
<?php
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
    "list_order_by_month"=>$this->list_order_by_month
),'admin_woopanel/app/assets/js/view_db_appointments_dashboard.js');