<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Language\Text;
$doc = Factory::getDocument();
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_config.less');
?>
<div class="view-config-form">
    <form action="" name="admin_woopanel-form" method="post" enctype="multipart/form-data">
        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#basic" aria-controls="home" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Basic','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#booking" aria-controls="profile" role="tab" data-toggle="tab">
                        <?php esc_html_e("Booking",'wpbookingpro') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="basic">
                    <div class="row">

                        <div class="col-lg-6 col-xl-4">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_service_detail','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_service_detail",wpbookingpro_get_content("Create page "))) ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-xl-4">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_list_category','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_list_category",wpbookingpro_get_content("Create page"))) ?>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <div class="block-basic-item">
                                <?php echo ($this->form->renderField('page_list_service','params')) ?>
                                <?php echo(ToolBar::render_button_task("config.create_page_list_service",wpbookingpro_get_content("Create page"))) ?>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div role="tabpanel" class="tab-pane" id="booking">
                    <div class="row">
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('booking_style','params')) ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('timezone','params')) ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('client_secret_file','params')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6 col-xl-4">
                            <?php
                            $field = $this->form->getField('multi_product_in_cart','params');
                            echo ($field->input)
                            ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php
                            $field = $this->form->getField('is_edit_sync_on_woommerce','params');
                            echo ($field->input)
                            ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php
                            $field = $this->form->getField('is_enable_add_google_calendar_api','params');
                            echo ($field->input)
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('order_status_config_when_scan','params')) ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php
                            $field = $this->form->getField('is_enable_send_sms','params');
                            echo ($field->input)
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('radius_for_search','params')) ?>
                        </div>
                        <div class="col-lg-6 col-xl-4">
                            <?php echo($this->form->renderField('unit_for_search','params')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="config.save">
    </form>
</div>
