<?php

namespace WpBookingProAdminWooPanel\app\views\config;

use WpBookingPro\Factory;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Mvc\View\View;
use WpBookingProAdminWooPanel\app\helpers\ConfigHelper;

class ConfigView extends View
{
    public function display($tpl)
    {
        if ($tpl == "list") {
            $tpl = "form";
        }
        switch ($tpl) {
            case "form":
                $modelConfig = ModelAlias::getInstance('config');
                $input = Factory::getInput();
                $id = $input->getInt('id');
                $this->item = $modelConfig->getItem(1);
                $this->form = $modelConfig->getForm();
                ToolBar::setTitle("Config Application");
                ToolBar::save("config.save");
                return parent::display($tpl);
                break;
            case "install":
                $tmpl_short_path = "/views/config/tmpl/install.php";
                $tmpl_path = WPBOOKINGPRO_APP_BACKEND_PATH . $tmpl_short_path;
                $debug = "";
                $wordpress = Factory::getWordpress(1);
                if (file_exists($tmpl_path)) {
                    ob_start();
                    include $tmpl_path;
                    $content = ob_get_clean();
                    if (!trim($content)) {
                        $content = "<div class='wrapper-woo-booking'><p>layout <b>$tmpl_short_path</b> empty please add content to it</p></div>";
                    }
                    $content = "<div class=\"wrapper-woo-booking\">$content</div>";
                    $doc = Factory::getDocument();
                    $wordpress->wp_add_inline_script();
                    return $content;
                } else {
                    throw new Exception(Text::_("Error:tpl <b>$tpl</b> not exits, please create it in view <b>" . $this->view . "</b>"));
                }
                break;
        }
    }
}