<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List category");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("category.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-category">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"><?php echo (HtmlBackend::render_checkbox('All')) ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Name','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Image','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Description','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="category-name nowrap"><?php esc_html_e($item->name); ?></td>
                        <td class="category-image nowrap">
                            <div class="img-box">
                                <div>
                                    <img class="category-image" src="<?php esc_html_e(FactoryAlias::getRootUrlPlugin())  ?>/<?php esc_html_e($item->image); ?>" alt="category-image"/>
                                </div>
                            </div>
                        </td>
                        <td class="category-description nowrap">
                            <?php esc_html_e($item->description); ?>
                        </td>
                        <td class="category-id nowrap"><?php esc_html_e($item->id); ?></td>
                        <td class="category-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("category.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("category","category.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_category.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-category', 'view_list_category', array(

), "admin_woopanel/app/assets/js/view_list_category.js");
?>