<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('moment');
WpBookingProHtmlWooPanelAlias::load_jquery_library('fullcalendar');
WpBookingProHtmlWooPanelAlias::load_jquery_library('loading_js');
ToolBar::setTitle("Calendar");
$list_employee = $this->list_employee;
?>
<?php ?>
    <div class="view-list-calendar">
        <div class="wrapper-employee">
           <ul class="list-employee">
               <li class="employee-item active" data-employee_id="0">
                   <div class="wrapper-img">
                       <div class="block-image">
                           <span><?php esc_attr_e('All', 'wpbookingpro');?></span>
                       </div>
                   </div>
                   <p class="text"><?php esc_attr_e('All employees', 'wpbookingpro');?></p>
               </li>
               <?php foreach ($list_employee as $employee) {?>
                   <li class="employee-item" data-employee_id="<?php esc_html_e($employee->id);?>">
                       <div class="wrapper-img">
                           <div class="img-box">
                               <div>
                                   <img src="<?php echo(FactoryAlias::getRootUrlPlugin())?><?php esc_html_e($employee->cover);?>" alt="">
                               </div>
                           </div>
                       </div>
                       <p class="employee-name"><?php echo($employee->first_name.' '.$employee->last_name);?></p>
                   </li>
                <?php }?>
           </ul>
        </div>
        <div id="calendar"></div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_calendar.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-calendar','view_list_calendar',array(
    "list_order"=>  $this->list,
),'admin_woopanel/app/assets/js/view_list_calendar.js');
?>