<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');
WpBookingProHtmlWooPanelAlias::load_jquery_library('loading_js');
ToolBar::setTitle("List Appointments");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
<form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("appointment.form")) ?>" name="admin_woopanel-form" method="post">
    <div class="view-list-appointment">
        <div class="wrapper-table-appointment">
            <table id="example" class="display table">
                <thead>
                    <tr class="header table-info">
                        <th></th>
                        <th><?php esc_attr_e('Customer','wpbookingpro')?></th>
                        <th><?php esc_attr_e('Payment','wpbookingpro')?></th>
                        <th><?php esc_html_e('Recurring','wpbookingpro')?></th>
                        <th><?php esc_html_e('Number day','wpbookingpro')?></th>
                        <th><?php esc_attr_e('Status','wpbookingpro')?></th>
                        <th><?php esc_attr_e('Action','wpbookingpro')?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item) { ?>
                            <tr class="row-item-order" data-order_id="<?php esc_html_e($item->id) ?>">
                                <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                                <td class="item-name"><?php esc_html_e($item->customer->customer_full_name) ?></td>
                                <td class="appoitment-price"><?php esc_html_e(HtmlBackend::render_price($item->total)); ?></td>
                                <td class="appointment-recurring">
                                    <?php
                                    if($item->is_recurring == 0) {
                                        esc_html_e('None','wpbookingpro');
                                    } else {
                                        if($item->type_recurring == 'daily') {
                                            esc_html_e('Daily','wpbookingpro');
                                        } else if($item->type_recurring == 'weekly') {
                                            esc_html_e('Weekly','wpbookingpro');
                                        } else if($item->type_recurring == 'monthly') {
                                            esc_html_e('Monthly','wpbookingpro');
                                        }
                                    }
                                    ?>
                                </td>
                                <td class="appointment-day">
                                    <?php
                                    if($item->is_recurring == 0) {
                                        echo 1;
                                    } else {
                                        echo (esc_html($item->number_day_recurring));
                                    }
                                    ?>
                                </td>
                                <td class="appoitment-status nowrap">
                                    <div class="list-order-status">
                                        <select class="order-status">
                                            <?php foreach ($this->list_order_status as $order_status) { ?>
                                                <option <?php echo($order_status->open_source_order_status_id == $item->open_source_order_status_id ? ' selected ' : '') ?>
                                                    value="<?php esc_html_e($order_status->open_source_order_status_id); ?>"><?php esc_html_e($order_status->title); ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </td>
                                <td class="appoitment-detail">
                                    <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("appointment.form",array('id'=>$item->id))) ?>" class="btn btn-primary btn-detail" title="<?php esc_attr_e('Detail','wpbookingpro')?>"><?php esc_attr_e('Detail','wpbookingpro')?></a>
                                </td>
                            </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/list_view_appointment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-appointment', 'list_view_appointment', array(

), "admin_woopanel/app/assets/js/list_view_appointment.js");
?>