<?php
use WpBookingPro\Language\Text;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;

WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
$item = $this->item;
?>
<div class="view-appointment-form">
    <form action="" name="admin_woopanel-form" method="post" enctype="multipart/form-data">
        <table id="example" class="display table"">
            <?php if(count($item->list_order_detail))  { ?>
                <thead>
                    <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
                        <th class="nowrap"><?php esc_html_e('Start date','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('End date','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Start time','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('End time','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Assign to','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Service','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Duration','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Location','wpbookingpro')?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_order_detail as $order_detail) { ?>
                        <tr class="list-rate-info list-rate-info-<?php esc_attr_e($item->id); ?>">
                            <td>
                                <?php
                                if($item->is_recurring == 0) {
                                    echo (esc_html(HtmlBackend::render_date($order_detail->rate->start_date,'Y-m-d')));
                                } else {
                                    echo (esc_html($order_detail->rate->date_start_recurring));
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if($item->is_recurring == 0) {
                                    echo (esc_html(HtmlBackend::render_date($order_detail->rate->end_date,'Y-m-d')));
                                } else {
                                    echo (esc_html($order_detail->rate->date_end_recurring));
                                }
                                ?>
                            </td>
                            <td class="nowrap">
                                <?php
                                if($item->is_recurring == 0) {
                                    echo (esc_html(HtmlBackend::render_date($order_detail->rate->start_date,"H:i")));
                                } else {
                                    echo (esc_html($order_detail->rate->time_start_recurring));
                                }

                                ?>
                            </td>
                            <td class="nowrap">
                                <?php
                                if($item->is_recurring == 0) {
                                    echo (esc_html(HtmlBackend::render_date($order_detail->rate->end_date,"H:i")));
                                } else {
                                    echo (esc_html($order_detail->rate->time_end_recurring));
                                }

                                ?>
                            </td>
                            <td class="employee">
                                <div class="img-box">
                                    <img class="employee-item-image pull-left" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin() . $order_detail->employee_image))  ?>" alt="employee-item-image" />
                                </div>
                                <h4 class="pull-left employee-item-name"><?php echo (esc_html($order_detail->employee_full_name)); ?></h4>
                            </td>
                            <td class="nowrap"><?php echo (esc_html($order_detail->service_name)); ?></td>
                            <td class="nowrap"><?php echo (esc_html($order_detail->rate->duration)) ?></td>
                            <td class="nowrap"><?php echo (esc_html($order_detail->location_address)); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            <?php }?>
        </table>
    </form>
</div>
<?php
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/list_form_appointment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-appointment-form', 'list_view_appointment', array(

), "admin_woopanel/app/assets/js/list_view_appointment.js");
?>
