<?php
namespace WpBookingProAdminWooPanel\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class WishlistsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "wishlists";
    /**
     * @var string
     */
    public $table_name = "wishlist";
    public function getListQuery()
    {
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('wishlist.*')
            ->from($this->getTableName() . ' AS wishlist')
            ->leftJoin($this->getTableName('service') . ' AS service ON service.id =wishlist.service_id')
            ->group('wishlist.service_id')
            ->select('service.name  AS service_name')
            ->select("COUNT(wishlist.service_id) AS total");
        return $query;
    }
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();
        $list =  $db->setQuery($query)->loadObjectList();

        return $list;
    }
}
