<?php
namespace WpBookingProAdminWooPanel\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";

    public function getItem($id = 0)
    {
        $item= parent::getItem($id); // TODO: Change the autogenerated stub
        if(isset($item->id) && $item->id !=0) {
            $query = $this->db->getQuery(true);
            $query->select('order_detail.*')
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$item->id);
            $item->order_detail = $this->db->setQuery($query)->loadObject();

            $query->select('customer.*')
                ->from($this->getTableName('customer') . ' AS customer')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObject();
            if( $item->customer)
            {
                $item->customer->full_name=Utility::get_full_name($item->customer->first_name,$item->customer->last_name);
            }
        }
        return $item;
    }
    public function change_order_status($order_id, $order_status_id)
    {
        $data = array(
            "id" => $order_id,
            "order_status_id" => $order_status_id
        );
        $order = parent::save($data);
        return $order;
    }


}
