<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlBackend::load_jquery_library('dateselect');
WpBookingProHtmlBackend::load_jquery_library('select2');

$doc = Factory::getDocument();
$list_open_source_user = get_users();
$id_by_name = "element_field_". $name;
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-wordpress_user">
        <select class="open-source-user" name="<?php esc_attr_e($name); ?>">
            <option value=""><?php esc_attr_e('None','wpbookingpro') ?></option>
			<?php foreach ($list_open_source_user as $user) { ?>
                <option <?php echo ($value == $user->get('ID') ? ' selected ' : '') ?>
                        value="<?php esc_attr_e($user->get('ID')) ?>"><?php esc_html_e($user->get('user_login')) ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/wordpressuser/wordpressuser.less');
$doc->addScriptApplySelector('.field-wordpress_user','field_wordpress_user',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/wordpressuser/wordpressuser.jquery.js');
