<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlWooPanelAlias::load_jquery_library('auto_numeric');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');



$doc = Factory::getDocument();
$list_order_status_woo = wc_get_order_statuses();
$id_by_name = $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$input = Factory::getInput();
$id = $input->getInt('id',0);
$db = Factory::getDBO();
$query = $db->getQuery(true);
$query->select('order_status.open_source_order_status_id')
    ->from(Utility::getTableName('order_status').' AS order_status')
;
$list_order_status_appointment = $db->setQuery($query)->loadColumn();
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-woocommerceorderstatus">
        <div class="wrapper-woocommerceorderstatus">
            <select class="woocommerceorderstatus" name="<?php esc_attr_e($name); ?>">
                <option value=""><?php esc_html_e('Select status','wpbookingpro')?></option>
                <?php foreach ($list_order_status_woo as $key => $item){ ?>
                    <?php $order_status_key = str_replace('wc-','',$key); ?>
                    <?php if ($id > 0) {?>
                        <option <?php echo ($order_status_key===$value?' selected ':'') ?> value="<?php esc_attr_e($order_status_key); ?>" <?php esc_attr_e($order_status_key===$value?'':'disabled');?>><?php esc_html_e($item,'wpbookingpro'); ?></option>
                    <?php } else {?>
                        <option <?php echo (in_array($order_status_key,$list_order_status_appointment)?'disabled':'') ?> value="<?php esc_attr_e($order_status_key); ?>"><?php esc_html_e($item,'wpbookingpro'); ?></option>
                    <?php }?>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/woocommerceorderstatus/woocommerceorderstatus.less');
$doc->addScriptApplySelector("#$id_by_name",'field_woocommerceorderstatus',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/woocommerceorderstatus/jquery.woocommerceorderstatus.js');
