<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = $value;
$list_view = HtmlBackend::function_get_view();
WpBookingProHtmlBackend::load_jquery_library('icheck');
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-views">
        <ul class=" list-view">
			<?php foreach ($list_view as $view) { ?>
                <li>
                    <label>
                        <input type="checkbox" name="<?php esc_attr_e($name); ?>[]" value="<?php esc_attr_e($view->menu_slug); ?>" <?php echo ($view->is_system) || in_array($view->menu_slug,
                            $list_selected) ? ' checked ' : '' ?> <?php echo ($view->is_system ? ' disabled ' : '') ?> />
                        <?php esc_html_e($view->label); ?>
                    </label>
                </li>
			<?php } ?>
        </ul>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/views/views.less');
$doc->addScriptApplySelector('.field-views','field_views',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/views/views.jquery.js');
