<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdminWooPanel\app\helpers\CustomizeHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlWooPanel::load_jquery_library('dateselect');
WpBookingProHtmlWooPanel::load_jquery_library('select2');


$doc = Factory::getDocument();
$list_table_view = CustomizeHelper::getListTableView();

$id_by_name = "element_field_". $name;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-tableview">
        <select class="table-view" name="<?php echo(esc_attr($name)); ?>" <?php echo ($disabled?" disabled ":"") ?> >
            <option value=""><?php esc_attr_e('Select table','wpbookingpro') ?></option>
			<?php foreach ($list_table_view as $table) { ?>
                <?php
                    $table = str_replace('woobooking_','',$table);
                ?>
                <option <?php echo ($value == $table ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($table)) ?>"><?php echo (ucfirst(str_replace('_',' ',$table))) ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/tableview/tableview.less');
$doc->addScriptApplySelector('.field-tableview','field_tableview',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/tableview/tableview.jquery.js');
