<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$servicesModel = Model::getInstance('services');
$list_services = $servicesModel->getList();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php esc_attr_e($id_by_name) ?>"
         class="<?php esc_attr_e($class); ?> field-services-<?php esc_attr_e($name_format) ?> field-services">
        <select name="<?php esc_attr_e($name); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-services">
            <option value=""> <?php esc_html_e('Select services','wpbookingpro') ?></option>
			<?php foreach ($list_services as $service) { ?>
                <option <?php echo (in_array($service->id, $list_selected) ? " selected " : "") ?>
                        value="<?php esc_attr_e($service->id); ?>"><?php esc_html_e($service->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/services/services.less');
$doc->addScriptApplySelector('.field-services','field_services',array(
    "field_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/services/services.jquery.js');
