<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$modelCategories = Model::getInstance('categories');
$list = $modelCategories->getList();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-servicecategory">
        <select name="<?php esc_html_e($name); ?>" <?php echo($multiple ? ' multiple ' : '')  ?>
                class="list-servicecategory">
            <option value=""><?php esc_attr_e('Select category','wpbookingpro') ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo($item->id == $value ? ' selected ' : ''); ?>
                        value="<?php esc_html_e($item->id); ?>"><?php esc_html_e($item->name); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/servicecategory/servicecategory.less');
$doc->addScriptApplySelector('.field-servicecategory','field_servicecategory',array(
    "field_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/servicecategory/servicecategory.jquery.js');
