<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$seasonsModel = Model::getInstance('seasons');
$list_seasons = $seasonsModel->getList_season_public();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php esc_attr_e($id_by_name) ?>"
         class="<?php esc_attr_e($class); ?> field-seasons-<?php esc_attr_e($name_format) ?> field-seasons">
        <select name="<?php esc_attr_e($name); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="form-control list-seasons">
            <option value=""> <?php esc_html_e('Select seasons','wpbookingpro') ?></option>
			<?php foreach ($list_seasons as $season) { ?>
                <option <?php echo (in_array($season->id, $list_selected) ? " selected " : "") ?>
                        value="<?php esc_attr_e($season->id); ?>"><?php esc_html_e($season->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/seasons/seasons.less');
$doc->addScriptApplySelector('.field-seasons','field_seasons',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/seasons/seasons.jquery.js');
