"use strict";
(function ($) {
    $.field_rates = function (element, options) {
        var defaults = {
            input_name: "",
            list_rate: ""
        };
        var plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);

            let $input_element=$element.find('.calendar_rates');
            $input_element.daterangepicker({
                opens: 'left',
                timePicker: true,
                locale: {
                    format: 'M/DD/YYYY hh:mm A'
                },
                isInvalidDate: function(date) {
                    if (date.format('YYYY-MM-DD') < moment().format('YYYY-MM-DD')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }, function (start, end, label) {
                $input_element = $(this.element);
                let $item = $input_element.closest('.item');
                let rate = `${start.format('YYYY-MM-DD hh:mm:ss')};${end.format('YYYY-MM-DD hh:mm:ss')}`;
                $item.find(`input[name="${plugin.settings.input_name}"]`).val(rate);
            });

        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_rates = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_rates')) {
                var plugin = new $.field_rates(this, options);
                $(this).data('field_rates', plugin);
            }
        });
    }
})(jQuery);
