<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlBackendAlias::load_jquery_library('dateselect');
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.less');
$id_by_name = "element_field_". $name;
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-mediabrowser">
        <div class="show-image">
            <div>
                <img class="media-show" src="<?php echo($value) ?>">
            </div>
        </div>
        <div class="input-group">
            <input name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>" type="text"
                   class="form-control">
            <span class="input-group-btn">
        <button class="btn btn-default btn-browser-media" type="button">Browser</button>
      </span>
        </div><!-- /input-group -->
    </div>
<?php
$doc->addScriptApplySelector('.field-mediabrowser','field_mediabrowser',array(
    "input_name"=>  $name,
    "multiple"=>  $multiple,
),'admin_woopanel/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.jquery.js');
