<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$locationsModel = Model::getInstance('locations');
$list_location = $locationsModel->getList();
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-location">
        <select name="<?php esc_attr_e($name); ?>" <?php $multiple ? ' multiple ' : null ?>
                class="form-control list-location">
            <option value="">Select location</option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo ($value == $location->id ? ' selected ' : '') ?>
                        value="<?php esc_attr_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlBackend::load_jquery_library('select2');
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/location/location.less');
$doc->addScriptApplySelector('.field-location','field_location',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/location/location.jquery.js');
