<?php

use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingProHtmlBackendAlias::load_jquery_library('select2');

$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-gender">
        <select class="list-gender" name="<?php esc_html_e($name); ?>">
            <option value=""><?php esc_attr_e('Select Gender','wpbookingpro') ?></option>
            <option <?php echo($value == 'a.ordering ASC' ? ' selected ' : '') ?> value="a.ordering ASC"><?php esc_attr_e('Male','wpbookingpro') ?></option>
            <option <?php echo($value == 'a.ordering DESC' ? ' selected ' : '') ?> value="a.ordering DESC"><?php esc_attr_e('Female','wpbookingpro') ?></option>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/gender/gender.less');
$doc->addScriptApplySelector('.field-gender', 'field_gender', array(
), 'admin_woopanel/app/layouts/WooBooking/form/field/gender/jquery.gender.js');
