<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('auto_numeric');
$doc = Factory::getDocument();
$employeesModel= ModelAlias::getInstance('employees');
$list_employees =$employeesModel->getList();
$input =Factory::getInput();
$event_id = $input->getInt('id', 0);
$modelEvent = ModelAlias::getInstance('event');
$modelService = ModelAlias::getInstance('service');
if($event_id > 0) {
    $event = $modelEvent->getItem($event_id);
    $service_id = reset($event->service_id);
    $list_employee_by_service = $modelService->getListEmployee($service_id);
} else {
    $list_employee_by_service = $list_employees;
}
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-employees">
        <div class="wrapper-employees">
            <select name="<?php esc_attr_e($name); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-employees">
                <option value="" disabled> <?php esc_html_e('Select employees','wpbookingpro') ?></option>
                <?php foreach ($list_employees as $employee) { ?>
                    <option <?php echo (in_array($employee->id, $list_selected) ? " selected " : "") ?>
                            value="<?php esc_attr_e($employee->id); ?>" <?php echo (in_array($employee->id, $list_employee_by_service) ? "" : "disabled") ?>><?php esc_html_e($employee->first_name . ' '. $employee->last_name); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/employees/employees.less');
$doc->addScriptApplySelector("#$id_by_name",'field_employees',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/employees/jquery.employees.js');
